/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.Date;
import java.util.Vector;
import org.notima.bg.BgParseException;
import org.notima.bg.BgSet;
import org.notima.bg.Transaction;
import org.notima.bg.bgmax.BgMaxTk05Record;
import org.notima.bg.bgmax.BgMaxTk15Record;

public class BgMaxSet
implements BgSet {
    private Vector<Transaction> records = new Vector();
    private BgMaxTk05Record setHeader;
    private BgMaxTk15Record setFooter;

    public BgMaxSet() {
    }

    public BgMaxSet(Date setDate, String currency, String clearing, String recipientBankAcct, String bgAccount) {
        this.setHeader = new BgMaxTk05Record();
        this.setHeader.setRecipientBg(bgAccount);
        this.setHeader.setCurrency(currency);
        this.setFooter = new BgMaxTk15Record();
        this.setFooter.setCurrency(currency);
        this.setFooter.setTransactionDate(setDate);
        this.setFooter.setToBankAccount(recipientBankAcct);
    }

    private void initSetHeader() {
        if (this.setHeader == null) {
            this.setHeader = new BgMaxTk05Record();
        }
    }

    @Override
    public void addTransaction(Transaction trans) {
        this.records.add(trans);
    }

    @Override
    public void setRecords(Vector<Transaction> records) {
        this.records = records;
    }

    @Override
    public Vector<Transaction> getRecords() {
        return this.records;
    }

    public void setSetHeader(BgMaxTk05Record setHeader) {
        this.setHeader = setHeader;
    }

    public void setSetFooter(BgMaxTk15Record setFooter) throws BgParseException {
        this.setFooter = setFooter;
        double total = 0.0;
        for (Transaction tr : this.records) {
            if (tr.getTransactionDate() == null) {
                tr.setTransactionDate(setFooter.getTransactionDate());
            }
            total += tr.getAmount();
        }
        if ((total = (double)Math.round(total * 100.0) / 100.0) != setFooter.getAmount()) {
            throw new BgParseException("Sum of transactions and footer sum is not equal: " + total + " != " + setFooter.getAmount());
        }
    }

    public void calculateFooter() {
        double total = 0.0;
        int count = 0;
        for (Transaction tr : this.records) {
            total += tr.getAmount();
            ++count;
        }
        total = (double)Math.round(total * 100.0) / 100.0;
        this.setFooter.setAmount(total);
        this.setFooter.setCount(count);
    }

    @Override
    public String getCurrency() {
        return this.setHeader.getCurrency();
    }

    public void setCurrency(String currency) {
        if (currency == null) {
            return;
        }
        this.initSetHeader();
        this.setHeader.setCurrency(currency.toUpperCase());
    }

    public void setRecipientBankAccount(String account) {
        if (account == null) {
            return;
        }
        this.initSetHeader();
        this.setHeader.setRecipientBg(account);
    }

    @Override
    public String getRecipientBankAccount() {
        return this.setHeader.getRecipientBg();
    }

    @Override
    public String getSenderBankAccount() {
        return null;
    }

    public BgMaxTk15Record generateFooter() throws BgParseException {
        if (this.setFooter == null) {
            this.setFooter = new BgMaxTk15Record();
        }
        this.setFooter.setCurrency(this.setHeader.getCurrency());
        this.calculateFooter();
        return this.setFooter;
    }

    @Override
    public String toRecordString() {
        StringBuffer lines = new StringBuffer();
        if (this.records == null || this.records.size() == 0) {
            return "";
        }
        lines.append(this.setHeader.toRecordString() + "\n");
        if (this.records != null && this.records.size() > 0) {
            for (int i = 0; i < this.records.size(); ++i) {
                Transaction receipt = this.records.get(i);
                receipt.setSeqNo(i + 1);
                lines.append(receipt.toRecordString());
            }
        }
        try {
            if (this.setFooter == null) {
                this.generateFooter();
            } else {
                this.calculateFooter();
            }
        }
        catch (BgParseException e) {
            e.printStackTrace();
        }
        lines.append(this.setFooter.toRecordString() + "\n");
        return lines.toString();
    }

    @Override
    public Date getCreditRecordDate(String recipientBg, double amount) {
        return null;
    }
}

