/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class BgMaxTk25Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("25(.*)");
    private String infoText;

    public BgMaxTk25Record() {
        super("25");
    }

    public BgMaxTk25Record(String text) {
        super("25");
        this.infoText = text;
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.infoText = m.group(1).trim();
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.transCode);
        line.append(BgUtil.fillToLength(this.infoText, false, ' ', 50));
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    public String getInfoText() {
        return this.infoText;
    }

    public void setInfoText(String infoText) {
        this.infoText = infoText;
    }
}

