/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class BgMaxTk28Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("28(.{35})(.{35})(.{2}).*");
    private String city;
    private String country;
    private String countryCode;

    public BgMaxTk28Record() {
        super("28");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.city = m.group(1).trim();
            this.country = m.group(2).trim();
            this.countryCode = m.group(3).trim();
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.transCode);
        line.append(BgUtil.fillToLength(this.city, false, ' ', 35));
        line.append(BgUtil.fillToLength(this.country, false, ' ', 35));
        if (this.countryCode != null && !"SE".equalsIgnoreCase(this.countryCode)) {
            line.append(BgUtil.fillToLength(this.countryCode.toUpperCase(), false, ' ', 2));
        }
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }
}

