/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.Date;
import java.util.Vector;
import org.notima.bg.BgFooter;
import org.notima.bg.BgHeader;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;
import org.notima.bg.Transaction;
import org.notima.bg.lb.AbstractLbSet;
import org.notima.bg.lb.LbPayment;
import org.notima.bg.lb.LbTk11Header;
import org.notima.bg.lb.LbTk20Record;
import org.notima.bg.lb.LbTk21Record;
import org.notima.bg.lb.LbTk29Record;

public class LbSet
extends AbstractLbSet {
    public static LbSet createPayableSet(String senderAccount) {
        String sA = BgUtil.toDigitsOnly(senderAccount);
        LbTk11Header h = new LbTk11Header(sA);
        LbTk29Record f = new LbTk29Record(sA, 0, 0.0);
        LbSet set = new LbSet(h, f);
        return set;
    }

    public LbSet(BgHeader header, BgFooter footer) {
        super(header, footer);
    }

    @Override
    public void addCreditRecord(BgRecord creditRecord) {
        if (creditRecord instanceof LbTk21Record) {
            LbTk21Record r = (LbTk21Record)creditRecord;
            Vector<LbTk21Record> recs = (Vector<LbTk21Record>)this.creditRecords.get(r.getRecipientBg());
            if (recs == null) {
                recs = new Vector<LbTk21Record>();
                this.creditRecords.put(r.getRecipientBg(), recs);
            }
            recs.add(r);
            for (Transaction tr : this.creditTransactions) {
                LbPayment payment = (LbPayment)tr;
                if (!payment.getDstBg().equals(r.getRecipientBg()) || Math.abs(tr.getAmount()) != r.getCreditAmount()) continue;
                payment.setTransactionDate(r.getCreditDate());
            }
        } else if (creditRecord instanceof LbTk20Record) {
            LbTk20Record r = (LbTk20Record)creditRecord;
            Vector<LbTk20Record> recs = (Vector<LbTk20Record>)this.creditRecords.get(r.getRecipientBg());
            if (recs == null) {
                recs = new Vector<LbTk20Record>();
                this.creditRecords.put(r.getRecipientBg(), recs);
            }
            recs.add(r);
        }
    }

    @Override
    public Date getCreditRecordDate(String recipientBg, double amount) {
        Vector recs = (Vector)this.creditRecords.get(recipientBg = BgUtil.trimLeadingZeros(BgUtil.toDigitsOnly(recipientBg)));
        if (recs == null) {
            return null;
        }
        for (BgRecord rec : recs) {
            LbTk21Record r;
            if (!(rec instanceof LbTk21Record) || amount != (r = (LbTk21Record)rec).getCreditAmount()) continue;
            return r.getCreditDate();
        }
        return null;
    }
}

