/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.Calendar;
import java.util.Date;
import org.notima.bg.BgHeader;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgSet;
import org.notima.bg.BgUtil;
import org.notima.bg.lb.LbUtlSet;

public class LbTk0Header
extends BgHeader {
    private String bgAccount = "";
    private String name = "";
    private String address = "";
    private Date fileDate;
    private Date payDate;

    public LbTk0Header(String senderAccount, String aName, String aAddress) {
        super("0");
        this.bgAccount = senderAccount;
        this.setHeaderType("LEVERANT\u00d6RSBETALNINGAR");
        this.fileDate = Calendar.getInstance().getTime();
        this.name = BgUtil.onlyUSASCII(aName);
        this.address = BgUtil.onlyUSASCII(aAddress);
    }

    @Override
    public Date getCreateDate() {
        return this.fileDate;
    }

    @Override
    public String getCurrency() {
        return null;
    }

    @Override
    public Date getPayDate() {
        return this.payDate;
    }

    @Override
    public String getSenderAccount() {
        return this.bgAccount;
    }

    @Override
    public void setCurrency(String currency) {
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        return null;
    }

    @Override
    public String toRecordString() {
        int bankId = 0;
        BgSet parentSet = this.getParentSet();
        if (parentSet != null && parentSet instanceof LbUtlSet) {
            bankId = ((LbUtlSet)parentSet).getBankId();
        }
        StringBuffer line = new StringBuffer(this.transCode);
        StringBuffer account = new StringBuffer();
        String bga = BgUtil.toDigitsOnly(this.bgAccount);
        account.append(bga);
        while (account.length() < 8) {
            account.insert(0, '0');
        }
        line.append(account);
        if (this.fileDate == null) {
            this.fileDate = Calendar.getInstance().getTime();
        }
        String dateStr = BgUtil.getDateString(this.fileDate);
        line.append(dateStr);
        line.append(BgUtil.fillToLength(this.name.toUpperCase(), false, ' ', 22));
        line.append(BgUtil.fillToLength(this.address.toUpperCase(), false, ' ', 35));
        if (this.payDate != null) {
            line.append(BgUtil.getDateString(this.payDate));
        } else {
            line.append("      ");
        }
        if (bankId == 1) {
            line.append("2");
        } else if (bga.length() == 8) {
            line.append("2");
        } else {
            line.append("1");
        }
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }
}

