/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;
import org.notima.bg.lb.LbPaymentRecord;

public class LbTk14Record
extends BgRecord
implements LbPaymentRecord {
    protected String recipientBg;
    protected String referenceBg;
    protected String ocrRef;
    protected double amount;
    protected Date payDate;
    protected String ourRefText;
    protected String payTypeCode;
    private static Pattern linePattern1 = Pattern.compile("14(\\d{9}[\\d|\\s])([\\w|\\s|\\W]{25})(\\d{12})(\\w)(\\d{10})(.*)");
    private static Pattern linePattern2 = Pattern.compile("14(\\d{10})([\\d|\\s]{25})(\\d{12})(\\d{6}).{5}(.*)");

    public LbTk14Record() {
        super("14");
    }

    @Override
    public LbTk14Record parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.recipientBg = BgUtil.trimLeadingZeros(m.group(1));
            this.ocrRef = m.group(2).trim();
            this.amount = BgUtil.parseAmountStr(m.group(3));
            this.payTypeCode = m.group(4);
            this.referenceBg = m.group(5);
            this.ourRefText = m.group(6).trim();
        } else {
            m = linePattern2.matcher(line);
            if (m.matches()) {
                this.recipientBg = BgUtil.trimLeadingZeros(m.group(1));
                this.ocrRef = m.group(2).trim();
                this.amount = BgUtil.parseAmountStr(m.group(3));
                try {
                    this.payDate = BgUtil.parseDateString(m.group(4));
                }
                catch (ParseException pe) {
                    throw new BgParseException("Can't parse date " + m.group(4), line);
                }
                this.ourRefText = m.group(5).trim();
            } else {
                throw new BgParseException(line);
            }
        }
        return null;
    }

    public LbTk14Record(double amount, String ourRef, Date payDate) {
        super("14");
        this.recipientBg = null;
        this.amount = amount;
        this.ourRefText = ourRef;
        this.payDate = payDate;
    }

    public LbTk14Record(String recipientBg, double amount, String ourRef) {
        super("14");
        this.recipientBg = BgUtil.toDigitsOnly(recipientBg);
        this.amount = amount;
        this.ourRefText = ourRef;
        this.payDate = null;
    }

    public String getOcrRef() {
        return this.ocrRef;
    }

    public void setOcrRef(String ocrRef) {
        this.ocrRef = ocrRef;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Override
    public Date getPayDate() {
        return this.payDate;
    }

    @Override
    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public String getOurRefText() {
        return this.ourRefText;
    }

    public void setOurRefText(String ourRefText) {
        this.ourRefText = ourRefText;
    }

    @Override
    public String toRecordString() {
        StringBuffer seqStr;
        StringBuffer line = new StringBuffer(this.getTransCode());
        if (this.recipientBg == null) {
            seqStr = new StringBuffer(Integer.toString(this.seqNo));
            while (seqStr.length() < 9) {
                seqStr.insert(0, "0");
            }
            seqStr.append(" ");
        } else {
            seqStr = new StringBuffer(this.recipientBg);
            while (seqStr.length() < 10) {
                seqStr.insert(0, "0");
            }
        }
        line.append(seqStr);
        StringBuffer ocrStr = new StringBuffer(this.ocrRef != null ? this.ocrRef : "");
        while (ocrStr.length() < 25) {
            ocrStr.append(" ");
        }
        line.append(ocrStr);
        line.append(BgUtil.getAmountStr(this.amount));
        line.append(BgUtil.getDateString(this.payDate));
        line.append("     ");
        if (this.ourRefText != null) {
            line.append(this.ourRefText);
        }
        while (line.length() < 80) {
            line.append(" ");
        }
        if (line.length() > 80) {
            line.setLength(80);
        }
        return line.toString();
    }
}

