/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class LbTk25Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("25(\\d{9})(.)(.*)");
    private String recipientBg;
    private String infoText;

    public LbTk25Record() {
        super("25");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (!m.matches()) {
            throw new BgParseException(line);
        }
        this.setRecipientBg((m.group(1) + m.group(2)).trim());
        this.setInfoText(m.group(3).trim());
        return this;
    }

    @Override
    public String toRecordString() {
        StringBuffer seqStr;
        StringBuffer line = new StringBuffer(this.getTransCode());
        if (this.recipientBg == null) {
            seqStr = new StringBuffer(Integer.toString(this.seqNo));
            while (seqStr.length() < 9) {
                seqStr.insert(0, "0");
            }
            seqStr.append(" ");
        } else {
            seqStr = new StringBuffer(this.recipientBg);
            while (seqStr.length() < 10) {
                seqStr.insert(0, "0");
            }
        }
        line.append(seqStr);
        if (this.getInfoText() != null && this.getInfoText().length() > 50) {
            this.setInfoText(this.getInfoText().substring(0, 50));
        }
        line.append(this.getInfoText());
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    public String getRecipientBg() {
        return this.recipientBg;
    }

    public void setRecipientBg(String recipientBg) {
        this.recipientBg = BgUtil.toDigitsOnly(recipientBg);
    }

    public String getInfoText() {
        return this.infoText;
    }

    public void setInfoText(String infoText) {
        this.infoText = infoText;
    }
}

