/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgFooter;
import org.notima.bg.BgParseException;
import org.notima.bg.BgUtil;

public class LbTk29Record
extends BgFooter {
    private String senderAccount;
    private static Pattern linePattern1 = Pattern.compile("29(\\d{10})(\\d{8})(\\d{12})(.{0,1}).*");

    public LbTk29Record() {
        super("29");
    }

    @Override
    public BgFooter parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.senderAccount = m.group(1);
            this.count = Integer.parseInt(m.group(2));
            this.amount = BgUtil.parseAmountStr(m.group(3));
            if ("-".equals(m.group(4))) {
                this.amount = -this.amount;
            }
        } else {
            throw new BgParseException(line);
        }
        return this;
    }

    public LbTk29Record(String senderAccount, int count, double totalAmount) {
        super("29");
        this.senderAccount = BgUtil.toDigitsOnly(senderAccount);
        this.setCount(count);
        this.setAmount(totalAmount);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer("29");
        StringBuffer accountStr = new StringBuffer(BgUtil.toDigitsOnly(this.senderAccount));
        while (accountStr.length() < 10) {
            accountStr.insert(0, "0");
        }
        line.append(accountStr.toString());
        StringBuffer countStr = new StringBuffer(Integer.toString(this.count));
        while (countStr.length() < 8) {
            countStr.insert(0, "0");
        }
        line.append(countStr);
        StringBuffer amountStr = new StringBuffer(BgUtil.getAmountStr(this.amount));
        while (amountStr.length() < 12) {
            amountStr.insert(0, "0");
        }
        line.append(amountStr);
        if (this.amount < 0.0) {
            line.append("-");
        }
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    public String getSenderAccount() {
        return this.senderAccount;
    }

    public void setSenderAccount(String senderAccount) {
        this.senderAccount = senderAccount;
    }
}

