/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;
import org.notima.bg.lb.LbPaymentRecord;

public class LbTk54Record
extends BgRecord
implements LbPaymentRecord {
    private static Pattern linePattern1 = Pattern.compile("54(\\d{10})(.{25})(\\d{12})(\\d|\\w)(\\d{10})(.*)");
    private String recipientPg;
    private String recipientPgRedirected;
    private String processCode;
    private double amount;
    private String ocrRef;
    private Date payDate;
    private String ourRefText;

    public LbTk54Record() {
        super("54");
    }

    public LbTk54Record(String recipientPg, String ocrRef, double amount, String ourRefText, Date payDate) {
        super("54");
        this.recipientPg = BgUtil.toDigitsOnly(recipientPg);
        this.amount = amount;
        this.ocrRef = BgUtil.toDigitsOnly(ocrRef);
        this.ourRefText = ourRefText;
        this.payDate = payDate;
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.recipientPg = BgUtil.trimLeadingZeros(m.group(1));
            this.ocrRef = m.group(2).trim();
            this.amount = BgUtil.parseAmountStr(m.group(3));
            this.processCode = m.group(4);
            this.recipientPgRedirected = BgUtil.trimLeadingZeros(m.group(5));
            this.ourRefText = m.group(6).trim();
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.getTransCode());
        StringBuffer seqStr = new StringBuffer(this.recipientPg);
        while (seqStr.length() < 10) {
            seqStr.insert(0, "0");
        }
        line.append(seqStr);
        StringBuffer ocrStr = new StringBuffer(this.ocrRef != null ? this.ocrRef : "");
        while (ocrStr.length() < 25) {
            ocrStr.append(" ");
        }
        line.append(ocrStr);
        line.append(BgUtil.getAmountStr(this.amount));
        line.append(BgUtil.getDateString(this.payDate));
        line.append("     ");
        if (this.ourRefText != null) {
            line.append(this.ourRefText);
        }
        while (line.length() < 80) {
            line.append(" ");
        }
        if (line.length() > 80) {
            line.setLength(80);
        }
        return line.toString();
    }

    public String getRecipientPg() {
        return this.recipientPg;
    }

    public void setRecipientPg(String recipientPg) {
        this.recipientPg = recipientPg;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getOcrRef() {
        return this.ocrRef;
    }

    public void setOcrRef(String ocrRef) {
        this.ocrRef = ocrRef;
    }

    @Override
    public Date getPayDate() {
        return this.payDate;
    }

    @Override
    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public String getOurRef() {
        return this.ourRefText;
    }

    public void setOurRef(String ourRef) {
        this.ourRefText = ourRef;
    }

    public String getRecipientPgRedirected() {
        return this.recipientPgRedirected;
    }

    public void setRecipientPgRedirected(String recipientPgRedirected) {
        this.recipientPgRedirected = recipientPgRedirected;
    }

    public String getProcessCode() {
        return this.processCode;
    }

    public void setProcessCode(String processCode) {
        this.processCode = processCode;
    }
}

