/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgSet;
import org.notima.bg.BgUtil;
import org.notima.bg.lb.LbUtlSet;

public class LbTk7Record
extends BgRecord {
    private int m_recipientNo;
    private int m_bankCode;
    private String m_hbAccountNo;
    private int bankId = 0;

    public LbTk7Record(int recipientNo, int bankCode, String hbAccountNo) {
        super("7");
        this.m_recipientNo = recipientNo;
        this.m_bankCode = bankCode;
        this.m_hbAccountNo = hbAccountNo;
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        return null;
    }

    @Override
    public String toRecordString() {
        BgSet parentSet = this.getParentSet();
        if (parentSet != null && parentSet instanceof LbUtlSet) {
            this.bankId = ((LbUtlSet)parentSet).getBankId();
        }
        StringBuffer line = new StringBuffer(this.getTransCode());
        line.append(BgUtil.fillToLength(Integer.toString(this.m_recipientNo), true, '0', 7));
        line.append(BgUtil.fillToLength(Integer.toString(this.m_bankCode), true, '0', 3));
        if (this.m_hbAccountNo != null && this.m_hbAccountNo.trim().length() > 0) {
            line.append("         DSE");
            line.append(BgUtil.toDigitsOnly(this.m_hbAccountNo));
        }
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    public int getBankId() {
        return this.bankId;
    }

    public void setBankId(int bankId) {
        this.bankId = bankId;
    }
}

