/*
 * Decompiled with CFR 0.152.
 */
package org.notima.generic.businessobjects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.notima.generic.businessobjects.Invoice;
import org.notima.generic.businessobjects.InvoiceLine;
import org.notima.generic.businessobjects.Order;
import org.notima.generic.businessobjects.OrderLine;
import org.notima.generic.businessobjects.TaxSummary;
import org.notima.generic.ifacebusinessobjects.BusinessObjectConverter;

public class BasicBusinessObjectConverter<O, I>
implements BusinessObjectConverter<O, I> {
    public static int DEFAULT_ROUNDING_DECIMALS = 2;

    public Order<O> copyOrder(Order<O> src) {
        Order dst = new Order();
        dst.setBillBpartner(src.getBillBpartner());
        dst.setBillLocation(src.getBillLocation());
        dst.setBillPerson(src.getBillPerson());
        dst.setBpartner(src.getBusinessPartner());
        dst.setCurrency(src.getCurrency());
        dst.setDocumentDate(src.getDocumentDate());
        dst.setGrandTotal(src.getGrandTotal());
        dst.setOrderKey(src.getOrderKey() != null ? src.getOrderKey() : src.getDocumentKey());
        dst.setShipLocation(src.getShipLocation());
        dst.setVatTotal(src.getVatTotal());
        ArrayList<OrderLine> olines = new ArrayList<OrderLine>();
        dst.setLines(olines);
        for (OrderLine iline : src.getLines()) {
            olines.add(this.copyOrderLine(iline));
        }
        dst.calculateGrandTotal();
        dst.setAttributes(src.getAttributes());
        return dst;
    }

    @Override
    public Invoice<I> toInvoice(Order<O> src) {
        Invoice dst = new Invoice();
        dst.setBillLocation(src.getBillLocation());
        dst.setBillPerson(src.getBillPerson());
        dst.setBusinessPartner(src.getBusinessPartner());
        dst.setCurrency(src.getCurrency());
        dst.setDocumentDate(src.getDocumentDate());
        dst.setGrandTotal(src.getGrandTotal());
        dst.setOrderKey(src.getDocumentKey());
        dst.setShipLocation(src.getShipLocation());
        dst.setVatTotal(src.getVatTotal());
        dst.setDeliveryDate(src.getDateDelivered());
        dst.setExternalReference1(src.getExternalReference1());
        dst.setExternalReference2(src.getExternalReference2());
        dst.setPaymentRule(src.getPaymentRule());
        dst.setPaymentTermKey(src.getPaymentTermKey());
        ArrayList<InvoiceLine> ilines = new ArrayList<InvoiceLine>();
        dst.setLines(ilines);
        for (OrderLine oline : src.getLines()) {
            ilines.add(this.toInvoiceLine(oline));
        }
        dst.calculateGrandTotal();
        dst.setAttributes(src.getAttributes());
        return dst;
    }

    public InvoiceLine toInvoiceLine(OrderLine src) {
        InvoiceLine dst = new InvoiceLine();
        dst.setKey(src.getKey());
        dst.setGroupKey(src.getGroupKey());
        dst.setName(src.getName());
        dst.setDescription(src.getDescription());
        dst.setProductKey(src.getProductKey());
        dst.setProduct(src.getProduct());
        dst.setLineNo(src.getLineNo());
        dst.setPriceActual(src.getPriceActual());
        dst.setQtyEntered(src.getQtyEntered());
        dst.setQtyDelivered(src.getQtyDelivered());
        dst.setTaxPercent(src.getTaxPercent());
        dst.setTaxKey(src.getTaxKey());
        dst.setTaxIncludedInPrice(src.isPricesIncludeVAT());
        dst.setUOM(src.getUOM());
        dst.calculateLineTotalIncTax(2);
        return dst;
    }

    @Override
    public Invoice<I> fromNativeInvoice(Object src) throws Exception {
        return null;
    }

    @Override
    public Order<O> toOrder(Invoice<I> src) {
        Order dst = new Order();
        dst.setBillBpartner(src.getBillBpartner());
        dst.setBillLocation(src.getBillLocation());
        dst.setBillPerson(src.getBillPerson());
        dst.setBpartner(src.getBusinessPartner());
        dst.setCurrency(src.getCurrency());
        dst.setDocumentDate(src.getDocumentDate());
        dst.setGrandTotal(src.getGrandTotal());
        dst.setOrderKey(src.getOrderKey() != null ? src.getOrderKey() : src.getDocumentKey());
        dst.setShipLocation(src.getShipLocation());
        dst.setVatTotal(src.getVatTotal());
        ArrayList<OrderLine> olines = new ArrayList<OrderLine>();
        dst.setLines(olines);
        for (InvoiceLine iline : src.getLines()) {
            olines.add(this.toOrderLine(iline));
        }
        dst.calculateGrandTotal();
        dst.setAttributes(src.getAttributes());
        return dst;
    }

    public OrderLine toOrderLine(InvoiceLine src) {
        OrderLine dst = new OrderLine();
        dst.setKey(src.getKey());
        dst.setGroupKey(src.getGroupKey());
        dst.setName(src.getName());
        dst.setDescription(src.getDescription());
        dst.setProductKey(src.getProductKey());
        dst.setProduct(src.getProduct());
        dst.setLineNo(src.getLineNo());
        dst.setPriceActual(src.getPriceActual());
        dst.setQtyEntered(src.getQtyEntered());
        dst.setQtyDelivered(src.getQtyDelivered());
        dst.setTaxPercent(src.getTaxPercent());
        dst.setTaxKey(src.getTaxKey());
        dst.setUOM(src.getUOM());
        dst.setLineNet(src.getLineNet());
        dst.setTaxAmount(src.getTaxAmount());
        dst.setLineNet(src.getLineNet());
        dst.setPricesIncludeVAT(src.isPricesIncludeVAT());
        dst.calculateLineTotalIncTax(2);
        return dst;
    }

    public OrderLine copyOrderLine(OrderLine src) {
        OrderLine dst = new OrderLine();
        dst.setKey(src.getKey());
        dst.setGroupKey(src.getGroupKey());
        dst.setName(src.getName());
        dst.setDescription(src.getDescription());
        dst.setProductKey(src.getProductKey());
        dst.setProduct(src.getProduct());
        dst.setLineNo(src.getLineNo());
        dst.setPriceActual(src.getPriceActual());
        dst.setQtyEntered(src.getQtyEntered());
        dst.setQtyDelivered(src.getQtyDelivered());
        dst.setTaxPercent(src.getTaxPercent());
        dst.setTaxKey(src.getTaxKey());
        dst.setUOM(src.getUOM());
        dst.setLineNet(src.getLineNet());
        dst.setTaxAmount(src.getTaxAmount());
        dst.setLineNet(src.getLineNet());
        dst.setPricesIncludeVAT(src.isPricesIncludeVAT());
        dst.calculateLineTotalIncTax(2);
        return dst;
    }

    public Order<O> negateOrder(Order<O> src) {
        if (src == null) {
            return null;
        }
        if (src.getOrderInvoiceLines() == null) {
            return src;
        }
        for (OrderLine ol : src.getLines()) {
            if (ol.getQtyEntered() != 0.0) {
                ol.setQtyEntered(-ol.getQtyEntered());
            }
            if (ol.getQtyDelivered() != 0.0) {
                ol.setQtyDelivered(-ol.getQtyDelivered());
            }
            ol.calculateLineTotalIncTax(DEFAULT_ROUNDING_DECIMALS);
        }
        src.calculateGrandTotal();
        return src;
    }

    public Order<O> createCreditOrderFromAmount(Order<O> src, double amount) {
        Order<O> dst = this.copyOrder(src);
        OrderLine singleLine = null;
        for (OrderLine ol : dst.getLines()) {
            if (ol.getLineNet() + ol.getTaxAmount() != amount) continue;
            singleLine = ol;
            break;
        }
        ArrayList<OrderLine> newList = new ArrayList<OrderLine>();
        if (singleLine != null) {
            newList.add(singleLine);
        } else {
            List tsl;
            double amountRemainingToCredit = amount;
            Map<String, TaxSummary> taxes = dst.calculateTaxSummary();
            TreeSet<Double> rates = new TreeSet<Double>();
            TreeMap taxMap = new TreeMap();
            for (String key : taxes.keySet()) {
                TaxSummary ts = taxes.get(key);
                rates.add(ts.getRate());
                tsl = (ArrayList<TaxSummary>)taxMap.get(ts.getRate());
                if (tsl == null) {
                    tsl = new ArrayList<TaxSummary>();
                    taxMap.put(ts.getRate(), tsl);
                }
                tsl.add(ts);
            }
            ArrayList rateList = new ArrayList();
            Iterator ii = rates.iterator();
            while (ii.hasNext()) {
                rateList.add(ii.next());
            }
            Collections.reverse(rateList);
            block3: for (Double rate : rateList) {
                if (amountRemainingToCredit <= 0.0) break;
                tsl = (List)taxMap.get(rate);
                double amountToCredit = 0.0;
                for (TaxSummary t : tsl) {
                    amountToCredit = amountRemainingToCredit <= t.getTaxBase() + t.getTaxAmount() ? amountRemainingToCredit : t.getTaxBase() + t.getTaxAmount();
                    singleLine = new OrderLine();
                    singleLine.setQtyEntered(1.0);
                    singleLine.setPricesIncludeVAT(true);
                    singleLine.setPriceActual(amountToCredit);
                    singleLine.setTaxPercent(t.getRate());
                    singleLine.calculateLineTotalIncTax(DEFAULT_ROUNDING_DECIMALS);
                    singleLine.setDescription("Kreditering");
                    newList.add(singleLine);
                    if (!((amountRemainingToCredit -= amountToCredit) <= 0.0)) continue;
                    continue block3;
                }
            }
        }
        dst.setLines(newList);
        dst.calculateGrandTotal();
        this.negateOrder(dst);
        return dst;
    }
}

