/*
 * Decompiled with CFR 0.152.
 */
package org.notima.generic.businessobjects;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.xml.bind.annotation.XmlRootElement;
import org.notima.bg.BgUtil;
import org.notima.generic.businessobjects.KeyValue;
import org.notima.generic.businessobjects.Location;
import org.notima.generic.businessobjects.Person;
import org.notima.generic.businessobjects.util.InvalidTaxIdFormatException;
import org.notima.generic.businessobjects.util.TaxIdFormatter;
import org.notima.generic.businessobjects.util.TaxIdStructure;
import org.notima.generic.businessobjects.util.UnknownTaxIdFormatException;

@Entity
@XmlRootElement(name="BusinessPartner")
public class BusinessPartner<B> {
    @Id
    @GeneratedValue
    private int bPartnerId;
    private boolean isCompany;
    private String name;
    private String taxId;
    private String vatNo;
    private String identityNo;
    private String language;
    private boolean emailInvoice;
    @ManyToOne
    private Location addressOfficial;
    @ManyToOne
    private Location addressShipping;
    private List<Person> contacts;
    private List<KeyValue> attributes;
    private Boolean isCustomer;
    private Boolean isVendor;
    private transient B nativeBusinessPartner;

    public int getbPartnerId() {
        return this.bPartnerId;
    }

    public void setbPartnerId(int bPartnerId) {
        this.bPartnerId = bPartnerId;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isCompany() {
        return this.isCompany;
    }

    public void setCompany(boolean isCompany) {
        this.isCompany = isCompany;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public String getTaxId(String format) throws UnknownTaxIdFormatException, InvalidTaxIdFormatException {
        if (format == null) {
            return this.taxId;
        }
        String countryCode = this.addressOfficial != null ? this.addressOfficial.getCountryCode() : null;
        this.taxId = BgUtil.removeBlanks(this.taxId);
        String origFormat = TaxIdFormatter.determineFormat(countryCode, this.taxId);
        if (origFormat == null || TaxIdStructure.FMT_UNKNOWN.equals(origFormat)) {
            return this.taxId;
        }
        String result = TaxIdFormatter.printTaxId(origFormat, this.taxId, format);
        return result;
    }

    public String getVatNo() {
        String countryCode;
        if (this.vatNo != null && this.vatNo.trim().length() > 0) {
            return this.vatNo;
        }
        if (this.taxId == null || this.taxId.trim().length() == 0) {
            return null;
        }
        String string = countryCode = this.addressOfficial != null ? this.addressOfficial.getCountryCode() : null;
        if (countryCode == null) {
            return null;
        }
        String format = TaxIdFormatter.determineFormat(countryCode, this.taxId);
        if (format == null || TaxIdStructure.FMT_UNKNOWN.equals(format)) {
            return null;
        }
        try {
            this.vatNo = TaxIdFormatter.printTaxId(format, this.taxId, TaxIdStructure.FMT_SE14);
        }
        catch (InvalidTaxIdFormatException | UnknownTaxIdFormatException e) {
            return null;
        }
        return this.vatNo;
    }

    public void setVatNo(String vatNo) {
        this.vatNo = vatNo;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isEmailInvoice() {
        return this.emailInvoice;
    }

    public void setEmailInvoice(boolean emailInvoice) {
        this.emailInvoice = emailInvoice;
    }

    public String getIdentityNo() {
        return this.identityNo;
    }

    public void setIdentityNo(String identityNo) {
        this.identityNo = identityNo;
    }

    public Location getAddressOfficial() {
        return this.addressOfficial;
    }

    public void setAddressOfficial(Location officialAddress) {
        this.addressOfficial = officialAddress;
    }

    public List<KeyValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<KeyValue> attributes) {
        this.attributes = attributes;
    }

    public Location getAddressShipping() {
        return this.addressShipping;
    }

    public void setAddressShipping(Location addressShipping) {
        this.addressShipping = addressShipping;
    }

    public List<Person> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<Person> contacts) {
        this.contacts = contacts;
    }

    public B getNativeBusinessPartner() {
        return this.nativeBusinessPartner;
    }

    public void setNativeBusinessPartner(B nativeBusinessPartner) {
        this.nativeBusinessPartner = nativeBusinessPartner;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.bPartnerId > 0) {
            result.append("bpId: " + this.bPartnerId);
        }
        if (this.taxId != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("taxId: " + this.taxId);
        }
        if (this.vatNo != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("vatNo: " + this.vatNo);
        }
        if (this.name != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(this.name);
        }
        result.insert(0, "{");
        result.append("}");
        return result.toString();
    }

    public Boolean getIsCustomer() {
        return this.isCustomer;
    }

    public void setIsCustomer(Boolean isCustomer) {
        this.isCustomer = isCustomer;
    }

    public Boolean getIsVendor() {
        return this.isVendor;
    }

    public void setIsVendor(Boolean isVendor) {
        this.isVendor = isVendor;
    }
}

