/*
 * Decompiled with CFR 0.152.
 */
package org.notima.generic.businessobjects;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.notima.generic.businessobjects.BankAccountDetail;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.InvoiceLine;
import org.notima.generic.businessobjects.KeyValue;
import org.notima.generic.businessobjects.Location;
import org.notima.generic.businessobjects.Person;
import org.notima.generic.ifacebusinessobjects.FactoringReservation;
import org.notima.generic.ifacebusinessobjects.OrderInvoice;
import org.notima.generic.ifacebusinessobjects.OrderInvoiceLine;

@Entity
@XmlRootElement(name="invoice")
public class Invoice<I>
implements OrderInvoice {
    private double lineNet;
    private int lineNo;
    private String invoiceKey;
    private String paymentTermKey;
    private String paymentRule;
    private String descriptionKey;
    @OneToMany
    private List<InvoiceLine> lines = new Vector<InvoiceLine>();
    private double netTotal;
    private double grandTotal;
    private double vatTotal;
    private double openAmt;
    @ManyToOne
    private BusinessPartner<?> bpartner;
    private String orderKey;
    @ManyToOne
    private Location billLocation;
    private Date invoiceDate;
    private Date dueDate;
    private Date deliveryDate;
    private Date contractStartDate;
    private Date contractEndDate;
    @ManyToOne
    private Person billPerson;
    @ManyToOne
    private Location shipLocation;
    @ManyToOne
    private BusinessPartner<?> billBpartner;
    @ManyToOne
    private BusinessPartner<?> sender;
    private String currency;
    private String ourCustomerNo;
    private String poDocumentNo;
    private String externalReference1;
    private String externalReference2;
    private int roundingDecimals = 2;
    private int nextLineNo = 10;
    private int lineNoIncrement = 10;
    @ManyToOne
    private FactoringReservation factoringReservation;
    private String warehouseId;
    @Id
    @GeneratedValue
    private String pricelistId;
    @ManyToOne
    private Person ourReference;
    @OneToMany
    private List<KeyValue> attributes = new ArrayList<KeyValue>();
    private String status;
    private Map<String, BankAccountDetail> bankAccountDetails = new TreeMap<String, BankAccountDetail>();
    private String ocr;
    private transient I nativeInvoice;

    public double round(double roundMe) {
        double multiplicator = Math.pow(10.0, this.roundingDecimals);
        double result = (double)Math.round(roundMe * multiplicator) / multiplicator;
        return result;
    }

    public double getLineNet() {
        return this.round(this.lineNet);
    }

    public void setLineNet(double lineNet) {
        this.lineNet = lineNet;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    @Override
    public String getPaymentTermKey() {
        return this.paymentTermKey;
    }

    public List<InvoiceLine> getLines() {
        return this.lines;
    }

    @Override
    public double getGrandTotal() {
        return this.round(this.grandTotal);
    }

    public double getOpenAmt() {
        return this.round(this.openAmt);
    }

    @Override
    public BusinessPartner<?> getBusinessPartner() {
        return this.bpartner;
    }

    public void setBusinessPartner(BusinessPartner<?> bpartner) {
        this.bpartner = bpartner;
    }

    public void addInvoiceLine(InvoiceLine il) {
        if (il.getLineNo() == 0) {
            il.setLineNo(this.nextLineNo);
            this.nextLineNo += this.lineNoIncrement;
        }
        this.lines.add(il);
    }

    public String getOrderKey() {
        return this.orderKey;
    }

    public void setOrderKey(String orderKey) {
        this.orderKey = orderKey;
    }

    public void setPaymentTermKey(String paymentTermKey) {
        this.paymentTermKey = paymentTermKey;
    }

    public String getPaymentRule() {
        return this.paymentRule;
    }

    public void setPaymentRule(String paymentRule) {
        this.paymentRule = paymentRule;
    }

    public void setLines(List<InvoiceLine> lines) {
        this.lines = lines;
        this.calculateGrandTotal();
    }

    @Override
    public void setGrandTotal(double grandTotal) {
        this.grandTotal = grandTotal;
    }

    public void setOpenAmt(double openAmt) {
        this.openAmt = openAmt;
    }

    public String getInvoiceKey() {
        return this.invoiceKey;
    }

    public void setInvoiceKey(String invoiceKey) {
        this.invoiceKey = invoiceKey;
    }

    public Location getBillLocation() {
        return this.billLocation;
    }

    public void setBillLocation(Location billLocation) {
        this.billLocation = billLocation;
    }

    @Override
    public String getDocumentKey() {
        return this.invoiceKey;
    }

    public Date getInvoiceDate() {
        return this.invoiceDate;
    }

    @Override
    public Person getBillPerson() {
        return this.billPerson;
    }

    @Override
    public Location getShipLocation() {
        return this.shipLocation;
    }

    @Override
    public BusinessPartner<?> getBillBpartner() {
        return this.billBpartner;
    }

    @Override
    public Date getDocumentDate() {
        return this.getInvoiceDate();
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public void setBillPerson(Person billPerson) {
        this.billPerson = billPerson;
    }

    public void setShipLocation(Location shipLocation) {
        this.shipLocation = shipLocation;
    }

    public void setBillBpartner(BusinessPartner<?> billBpartner) {
        this.billBpartner = billBpartner;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    @XmlTransient
    public FactoringReservation getFactoringReservation() {
        return this.factoringReservation;
    }

    @Override
    public void setFactoringReservation(FactoringReservation factoringReservation) {
        this.factoringReservation = factoringReservation;
    }

    @Override
    public void setDocumentKey(String key) {
        this.setInvoiceKey(key);
    }

    @Override
    public void setDocumentDate(Date date) {
        this.setInvoiceDate(date);
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    @Override
    public double getFreightAmount() {
        return 0.0;
    }

    @Override
    public String getShipmentNo() {
        return null;
    }

    @Override
    public boolean isCreditNote() {
        return this.grandTotal < 0.0;
    }

    @Override
    public String getOurCustomerNo() {
        return this.ourCustomerNo;
    }

    @Override
    public boolean isInvoice() {
        return true;
    }

    @Override
    public boolean isOrder() {
        return false;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setOurCustomerNo(String ourCustomerNo) {
        this.ourCustomerNo = ourCustomerNo;
    }

    public String getPoDocumentNo() {
        return this.poDocumentNo;
    }

    public void setPoDocumentNo(String poDocumentNo) {
        this.poDocumentNo = poDocumentNo;
    }

    @Override
    public double getVatTotal() {
        return this.round(this.vatTotal);
    }

    public void setVatTotal(double vatTotal) {
        this.vatTotal = vatTotal;
    }

    public double calculateGrandTotal() {
        double total = 0.0;
        this.vatTotal = 0.0;
        this.netTotal = 0.0;
        for (InvoiceLine line : this.lines) {
            total += line.calculateLineTotalIncTax(this.roundingDecimals);
            this.vatTotal += line.getTaxAmount();
            this.netTotal += line.getLineNet();
        }
        total = InvoiceLine.round(total, this.roundingDecimals);
        this.vatTotal = InvoiceLine.round(this.vatTotal, this.roundingDecimals);
        this.netTotal = InvoiceLine.round(this.netTotal, this.roundingDecimals);
        this.grandTotal = total;
        return total;
    }

    public int getRoundingDecimals() {
        return this.roundingDecimals;
    }

    public void setRoundingDecimals(int roundingDecimals) {
        this.roundingDecimals = roundingDecimals;
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getPricelistId() {
        return this.pricelistId;
    }

    public void setPricelistId(String pricelistId) {
        this.pricelistId = pricelistId;
    }

    public double getNetTotal() {
        return this.round(this.netTotal);
    }

    public void setNetTotal(double netTotal) {
        this.netTotal = netTotal;
    }

    @Override
    public BusinessPartner<?> getSender() {
        return this.sender;
    }

    public void setSender(BusinessPartner<?> sender) {
        this.sender = sender;
    }

    public Person getOurReference() {
        return this.ourReference;
    }

    public void setOurReference(Person ourReference) {
        this.ourReference = ourReference;
    }

    public String getExternalReference1() {
        return this.externalReference1;
    }

    public void setExternalReference1(String externalReference1) {
        this.externalReference1 = externalReference1;
    }

    public String getExternalReference2() {
        return this.externalReference2;
    }

    public void setExternalReference2(String externalReference2) {
        this.externalReference2 = externalReference2;
    }

    @Override
    public List<OrderInvoiceLine> getOrderInvoiceLines() {
        if (this.lines != null) {
            ArrayList<OrderInvoiceLine> oiLines = new ArrayList<OrderInvoiceLine>();
            oiLines.addAll(this.lines);
            return oiLines;
        }
        return null;
    }

    public List<KeyValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<KeyValue> attributes) {
        this.attributes = attributes;
    }

    public Map<String, BankAccountDetail> getBankAccountDetails() {
        return this.bankAccountDetails;
    }

    public void setBankAccountDetails(Map<String, BankAccountDetail> bankAccountDetails) {
        this.bankAccountDetails = bankAccountDetails;
    }

    public BankAccountDetail getBankAccountWithType(String type) {
        return this.bankAccountDetails.get(type);
    }

    public String getOcr() {
        return this.ocr;
    }

    public void setOcr(String ocr) {
        this.ocr = ocr;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public Date getContractStartDate() {
        return this.contractStartDate;
    }

    public void setContractStartDate(Date contractStartDate) {
        this.contractStartDate = contractStartDate;
    }

    public Date getContractEndDate() {
        return this.contractEndDate;
    }

    public void setContractEndDate(Date contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public I getNativeInvoice() {
        return this.nativeInvoice;
    }

    public void setNativeInvoice(I src) {
        this.nativeInvoice = src;
    }
}

