/*
 * Decompiled with CFR 0.152.
 */
package org.notima.generic.businessobjects;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.notima.generic.businessobjects.KeyValue;

@Entity
public class Location {
    @Id
    @GeneratedValue
    private int locationId;
    private String reference;
    private String customerReference;
    private String name;
    private String co;
    private String address1;
    private String address2;
    private String address3;
    private String address4;
    private String street;
    private String houseNo;
    private String postal;
    private String city;
    private String countryCode;
    private String email;
    private String phone;
    private List<KeyValue> attributes = new ArrayList<KeyValue>();

    public int getLocationId() {
        return this.locationId;
    }

    public void setLocationId(int locationId) {
        this.locationId = locationId;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getCustomerReference() {
        return this.customerReference;
    }

    public void setCustomerReference(String customerReference) {
        this.customerReference = customerReference;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCo() {
        return this.co;
    }

    public void setCo(String co) {
        this.co = co;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getAddress3() {
        return this.address3;
    }

    public void setAddress3(String address3) {
        this.address3 = address3;
    }

    public String getAddress4() {
        return this.address4;
    }

    public void setAddress4(String address4) {
        this.address4 = address4;
    }

    public String getPostal() {
        return this.postal;
    }

    public void setPostal(String postal) {
        this.postal = postal;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<KeyValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<KeyValue> attributes) {
        this.attributes = attributes;
    }

    public void trimAll() {
        if (this.address1 == null) {
            this.address1 = "";
        }
        if (this.address2 == null) {
            this.address2 = "";
        }
        if (this.address3 == null) {
            this.address3 = "";
        }
        if (this.address4 == null) {
            this.address4 = "";
        }
        if (this.postal == null) {
            this.postal = "";
        }
        if (this.city == null) {
            this.city = "";
        }
        if (this.countryCode == "") {
            this.countryCode = "";
        }
        if (this.email == null) {
            this.email = "";
        }
        if (this.phone == null) {
            this.phone = "";
        }
        if (this.name == null) {
            this.name = "";
        }
        this.address1 = this.address1.trim();
        this.address2 = this.address2.trim();
        this.address3 = this.address3.trim();
        this.address4 = this.address4.trim();
        this.postal = this.postal.trim();
        this.city = this.city.trim();
        this.countryCode = this.countryCode.trim().toUpperCase();
        this.email = this.email.trim();
        this.phone = this.phone.trim();
        this.name = this.name.trim();
    }

    public boolean equalsAll(Location loc) {
        if (!this.equalsAddress(loc)) {
            return false;
        }
        if (!this.email.equalsIgnoreCase(loc.email)) {
            return false;
        }
        if (!this.phone.equalsIgnoreCase(loc.phone)) {
            return false;
        }
        return this.name.equalsIgnoreCase(loc.name);
    }

    public boolean equalsAddress(Location loc) {
        this.trimAll();
        loc.trimAll();
        if (!this.address1.equalsIgnoreCase(loc.address1)) {
            return false;
        }
        if (!this.address2.equalsIgnoreCase(loc.address2)) {
            return false;
        }
        if (!this.address3.equalsIgnoreCase(loc.address3)) {
            return false;
        }
        if (!this.address4.equalsIgnoreCase(loc.address4)) {
            return false;
        }
        if (!this.postal.equalsIgnoreCase(loc.postal)) {
            return false;
        }
        if (!this.city.equalsIgnoreCase(loc.city)) {
            return false;
        }
        return this.countryCode.equals(loc.countryCode);
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getHouseNo() {
        return this.houseNo;
    }

    public void setHouseNo(String houseNo) {
        this.houseNo = houseNo;
    }
}

