/*
 * Decompiled with CFR 0.152.
 */
package org.notima.generic.businessobjects;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import org.notima.generic.businessobjects.InvoiceLine;
import org.notima.generic.businessobjects.Product;
import org.notima.generic.ifacebusinessobjects.OrderInvoiceLine;

@Entity
public class OrderLine
implements OrderInvoiceLine {
    private String groupKey;
    private String key;
    private String name;
    private double qtyEntered;
    private double qtyDelivered;
    private Date dateLastDelivered;
    private Double priceActual;
    private int lineNo;
    private String taxKey;
    private double taxPercent;
    private double taxAmount;
    private double lineNet;
    private String productKey;
    private String description;
    private String UOM;
    private Double priceNormal;
    private boolean pricesIncludeVAT;
    @ManyToOne
    private Product<?> product;

    public Product<?> getProduct() {
        return this.product;
    }

    public void setProduct(Product<?> product) {
        this.product = product;
    }

    public String toString() {
        return "[productKey=>" + this.productKey + "], [qtyEntered=>" + this.qtyEntered + "], [UOM=>" + this.UOM + "]";
    }

    @Override
    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getQtyEntered() {
        return this.qtyEntered;
    }

    public void setQtyEntered(double qtyEntered) {
        this.qtyEntered = qtyEntered;
    }

    public double getQtyDelivered() {
        return this.qtyDelivered;
    }

    public void setQtyDelivered(double qtyDelivered) {
        this.qtyDelivered = qtyDelivered;
    }

    public Date getDateLastDelivered() {
        return this.dateLastDelivered;
    }

    public void setDateLastDelivered(Date dateLastDelivered) {
        this.dateLastDelivered = dateLastDelivered;
    }

    @Override
    public Double getPriceActual() {
        if (this.priceActual == null && this.priceNormal != null) {
            return this.priceNormal;
        }
        return this.priceActual;
    }

    public void setPriceActual(Double priceActual) {
        this.priceActual = priceActual;
    }

    @Override
    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    @Override
    public String getTaxKey() {
        return this.taxKey;
    }

    public void setTaxKey(String taxKey) {
        this.taxKey = taxKey;
    }

    @Override
    public double getTaxPercent() {
        return this.taxPercent;
    }

    public void setTaxPercent(double taxPercent) {
        this.taxPercent = taxPercent;
    }

    public double calculateTaxPercent(double priceIncVat) {
        this.taxAmount = priceIncVat - this.priceActual;
        double taxP = this.taxAmount / this.priceActual;
        this.taxPercent = taxP = (double)Math.round(taxP * 100.0) / 100.0;
        this.lineNet = this.qtyEntered * (this.pricesIncludeVAT ? this.priceActual - this.taxAmount : this.priceActual);
        return this.taxPercent;
    }

    public double calculateLineTotalIncTax(int roundingDecimals) {
        double lineTotal;
        if (this.pricesIncludeVAT) {
            double lineIncTax = InvoiceLine.round(this.priceActual * this.qtyEntered, roundingDecimals);
            this.taxAmount = lineIncTax - lineIncTax / (1.0 + this.taxPercent / 100.0);
            this.taxAmount = InvoiceLine.round(this.taxAmount, roundingDecimals);
            this.lineNet = lineIncTax - this.taxAmount;
            lineTotal = lineIncTax;
        } else {
            this.lineNet = InvoiceLine.round(this.priceActual * this.qtyEntered, roundingDecimals);
            this.taxAmount = this.lineNet * (this.taxPercent / 100.0);
            this.taxAmount = InvoiceLine.round(this.taxAmount, roundingDecimals);
            lineTotal = this.lineNet * (1.0 + this.taxPercent / 100.0);
            lineTotal = InvoiceLine.round(lineTotal, roundingDecimals);
        }
        return lineTotal;
    }

    @Override
    public String getProductKey() {
        return this.productKey;
    }

    public void setProductKey(String productKey) {
        this.productKey = productKey;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getUOM() {
        return this.UOM;
    }

    public void setUOM(String uOM) {
        this.UOM = uOM;
    }

    @Override
    public Double getPriceNormal() {
        if (this.priceNormal == null && this.priceActual != null) {
            return this.priceActual;
        }
        return this.priceNormal;
    }

    public void setPriceNormal(Double priceNormal) {
        this.priceNormal = priceNormal;
    }

    @Override
    public boolean isPricesIncludeVAT() {
        return this.pricesIncludeVAT;
    }

    public void setPricesIncludeVAT(boolean pricesIncludeVAT) {
        this.pricesIncludeVAT = pricesIncludeVAT;
    }

    public double getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(double taxAmount) {
        this.taxAmount = taxAmount;
    }

    public double getLineNet() {
        return this.lineNet;
    }

    public void setLineNet(double lineNet) {
        this.lineNet = lineNet;
    }
}

