/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.Processor;

public class DestinationProcessor
implements Processor {
    private Logger logger = Logger.getLogger(DestinationProcessor.class.getCanonicalName());
    public Pattern sftpPattern = Pattern.compile("^sftp://(.*?)@(.*?):(\\d+)/(.*?)(\\?.*){0,1}");

    public List<String> splitDestinations(@Header(value="reconcileDestinations") String reconcileDestinations) {
        ArrayList<String> result = new ArrayList<String>();
        if (reconcileDestinations == null) {
            return result;
        }
        String[] list = reconcileDestinations.split(";");
        result.addAll(Arrays.asList(list));
        return result;
    }

    public List<String> splitFormats(@Header(value="reconcileFormats") String reconcileFormats) {
        ArrayList<String> result = new ArrayList<String>();
        if (reconcileFormats == null) {
            return result;
        }
        String[] list = reconcileFormats.split(";");
        result.addAll(Arrays.asList(list));
        return result;
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        String reconcileFormats = (String)headers.get("reconcileFormats");
        String reconcileFormat = null;
        Integer idx = (Integer)exchange.getProperty("CamelSplitIndex", Integer.class);
        List<String> formats = this.splitFormats(reconcileFormats);
        if (formats.size() > idx) {
            reconcileFormat = formats.get(idx);
        }
        if (reconcileFormat != null) {
            headers.put("reconcileFormat", reconcileFormat);
        } else {
            headers.remove("reconcileFormat");
        }
    }
}

