/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.camel.Header;

public class FileUtil {
    public static final String DEFAULT_FILE_ENCODING = "UTF-8";

    public String getFileName(String filePath) {
        File f = new File(filePath);
        return f.getName();
    }

    public String getFileNameWoSuffix(String filePath) {
        File f = new File(filePath);
        String name = f.getName();
        int idx = name.lastIndexOf(".");
        if (idx > 0) {
            return name.substring(0, idx);
        }
        return name;
    }

    public StringBuffer readFile(@Header(value="filePath") String filePath, @Header(value="fileEncoding") String fileEncoding) throws IOException {
        String line;
        if (fileEncoding == null || fileEncoding.trim().length() == 0) {
            fileEncoding = DEFAULT_FILE_ENCODING;
        }
        BufferedReader textReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), Charset.forName(fileEncoding)));
        StringBuffer fileBody = new StringBuffer();
        while ((line = textReader.readLine()) != null) {
            fileBody.append(line + "\r\n");
        }
        textReader.close();
        return fileBody;
    }

    public byte[] readBinaryFile(@Header(value="filePath") String filePath) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(filePath))));
        byte[] binary = new byte[dis.available()];
        dis.readFully(binary);
        dis.close();
        return binary;
    }

    public StringBuffer mergeStringBufferList(List<StringBuffer> list) {
        StringBuffer result = new StringBuffer();
        if (list == null) {
            return null;
        }
        for (StringBuffer b : list) {
            if (b == null) continue;
            result.append(b.toString());
            result.append("\n");
        }
        return result;
    }
}

