/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Header;
import org.apache.camel.Property;
import org.notima.util.RuntimeUtil;

public class PrintLPR {
    public int listPrinters() throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("lpstat");
        cmd.add("-p");
        return RuntimeUtil.runExternalCmd(cmd, null, null);
    }

    public List<String> createOptionList(@Header(value="printOptionStr") String optionStr) {
        ArrayList<String> options = new ArrayList<String>();
        if (optionStr != null && optionStr.trim().length() > 0) {
            String[] opts = optionStr.split("\\s");
            for (int i = 0; i < opts.length; ++i) {
                options.add(opts[i]);
            }
        }
        return options;
    }

    public int print(@Property(value="printerName") String printerName, @Header(value="printFileName") String file, @Header(value="printPages") String pages, @Header(value="printOptions") List<String> options) throws Exception {
        if (file == null || file.trim().length() == 0) {
            throw new Exception("Parameter file is mandatory");
        }
        File f = new File(file);
        if (!f.exists()) {
            throw new Exception(String.valueOf(file) + " not found.");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("lp");
        if (printerName != null && printerName.trim().length() > 0) {
            cmd.add("-d");
            cmd.add(printerName);
        }
        if (options != null && options.size() > 0) {
            for (String o : options) {
                cmd.add("-o " + o);
            }
        }
        if (pages != null && pages.trim().length() > 0) {
            cmd.add("-P");
            cmd.add("1");
        }
        cmd.add(file);
        int result = RuntimeUtil.runExternalCmd(cmd, null, null);
        return result;
    }
}

