/*
 * Decompiled with CFR 0.152.
 */
package org.notima.util;

public class TaxIdStructure {
    public static String FMT_UNKNOWN = "UNKNOWN";
    public static String FMT_SE14 = "SE14";
    public static String FMT_SE12 = "SE12";
    public static String FMT_SE11 = "SE11";
    public static String FMT_SE10 = "SE10";
    protected String prefix;
    protected String leftmiddle;
    protected String rightmiddle;
    protected String suffix;
    protected String taxIdFormat;

    public TaxIdStructure(String taxIdFormat) {
        this.taxIdFormat = taxIdFormat;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getLeftmiddle() {
        return this.leftmiddle;
    }

    public void setLeftmiddle(String leftmiddle) {
        this.leftmiddle = leftmiddle;
    }

    public String getRightmiddle() {
        return this.rightmiddle;
    }

    public void setRightmiddle(String rightmiddle) {
        this.rightmiddle = rightmiddle;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getTaxIdFormat() {
        return this.taxIdFormat;
    }

    public void setTaxIdFormat(String taxIdFormat) {
        this.taxIdFormat = taxIdFormat;
    }

    public boolean isValidDateSE() {
        int year = Integer.parseInt(this.prefix);
        int month = Integer.parseInt(this.leftmiddle);
        int day = Integer.parseInt(this.rightmiddle);
        if (year > 100 && (year <= 1700 || year >= 2300)) {
            return false;
        }
        if (month > 13) {
            return false;
        }
        return day <= 31;
    }

    public String printTaxId(String dstFormat) {
        String result = null;
        if (FMT_SE10.equalsIgnoreCase(dstFormat)) {
            result = this.prefix.substring(this.prefix.length() - 2, this.prefix.length()) + this.leftmiddle + this.rightmiddle + this.suffix;
        } else if (FMT_SE11.equalsIgnoreCase(dstFormat)) {
            result = this.prefix.substring(this.prefix.length() - 2, this.prefix.length()) + this.leftmiddle + this.rightmiddle + "-" + this.suffix;
        } else if (FMT_SE12.equalsIgnoreCase(dstFormat)) {
            if (!FMT_SE12.equalsIgnoreCase(this.taxIdFormat) && this.prefix.length() < 4) {
                this.prefix = this.isValidDateSE() ? "XX" + this.prefix : "16" + this.prefix;
            }
            result = this.prefix + this.leftmiddle + this.rightmiddle + this.suffix;
        } else if (FMT_SE14.equalsIgnoreCase(dstFormat)) {
            result = "SE" + this.prefix + this.leftmiddle + this.rightmiddle + this.suffix + "01";
        }
        return result;
    }
}

