/*
 * Decompiled with CFR 0.152.
 */
package org.notima.util;

import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RuntimeUtil {
    public static int runExternalCmd(List<String> cmd, final PropertyChangeSupport swingWorker, Properties customEnv) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Map<String, String> env = pb.environment();
        if (customEnv != null && !customEnv.isEmpty()) {
            for (Object key : customEnv.keySet()) {
                env.put(key.toString(), customEnv.getProperty(key.toString()));
            }
        }
        final Process p = pb.start();
        BufferedInputStream is = new BufferedInputStream(p.getInputStream());
        final BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
        BufferedInputStream es = new BufferedInputStream(p.getErrorStream());
        final BufferedReader er = new BufferedReader(new InputStreamReader((InputStream)es, "UTF-8"));
        Runnable errReaderT = new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = er.readLine()) != null) {
                        if (swingWorker != null) {
                            swingWorker.firePropertyChange("stderr", null, line);
                            continue;
                        }
                        System.err.println(line);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        Runnable outReaderT = new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (swingWorker != null) {
                            swingWorker.firePropertyChange("stdout", null, line);
                            continue;
                        }
                        System.out.println(line);
                    }
                }
                catch (IOException ioe1) {
                    ioe1.printStackTrace();
                }
            }
        };
        Runnable extRunnerT = new Runnable(){

            @Override
            public void run() {
                try {
                    p.waitFor();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        };
        Thread errReaderThread = new Thread(errReaderT, "errReader");
        Thread outReaderThread = new Thread(outReaderT, "outReader");
        Thread extRunnerThread = new Thread(extRunnerT, "runner");
        errReaderThread.start();
        outReaderThread.start();
        extRunnerThread.start();
        while (extRunnerThread.isAlive()) {
            extRunnerThread.join(5000L);
        }
        return p.exitValue();
    }
}

