/*
 * Decompiled with CFR 0.152.
 */
package org.notima.util;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.notima.util.BankDateUtil_SE;

public class BankDateUtil {
    private static String countryCode;
    protected static String startDate;
    protected static int days;
    private static LocalDate returnDate;

    public static String bankDateCalculator(String[] args) {
        BankDateUtil.readArgs(args);
        switch (countryCode) {
            case "SE": {
                BankDateUtil_SE bdu_SE = new BankDateUtil_SE(startDate, days);
                bdu_SE.calculateDate();
                break;
            }
            default: {
                System.out.println("Not a valid country code");
            }
        }
        return returnDate.toString();
    }

    private static void readArgs(String[] args) {
        if (args == null || args.length != 3) {
            System.out.println("Can only have and must have 3 arguments");
            System.exit(1);
        }
        countryCode = args[0];
        startDate = args[1];
        days = Integer.parseInt(args[2]);
    }

    protected static void calculateNewDate(List<String> holidays) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try {
            LocalDate initialDate = LocalDate.parse(startDate, formatter);
            LocalDate date = LocalDate.from(initialDate);
            int i = 1;
            while (i <= days) {
                date = date.plusDays(1L);
                for (String holiday : holidays) {
                    boolean isHoliday = BankDateUtil.isHoliday(holiday, date, formatter);
                    Boolean isWeekend = BankDateUtil.isWeekend(date);
                    if (!isHoliday && !isWeekend.booleanValue()) continue;
                    --i;
                    break;
                }
                ++i;
            }
            returnDate = date;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isHoliday(String holiday, LocalDate date, DateTimeFormatter formatter) {
        boolean setHoliday;
        boolean movableHoliday = false;
        if (holiday.charAt(0) != 'x') {
            LocalDate dateCheck = LocalDate.parse(holiday, formatter);
            movableHoliday = date.equals(dateCheck);
        }
        boolean bl = setHoliday = holiday.charAt(0) == 'x' && date.getMonthValue() == Integer.parseInt(holiday.substring(5, 7)) && date.getDayOfMonth() == Integer.parseInt(holiday.substring(8, 10));
        return movableHoliday || setHoliday;
    }

    private static boolean isWeekend(LocalDate dt) {
        switch (dt.getDayOfWeek()) {
            case SATURDAY: {
                return true;
            }
            case SUNDAY: {
                return true;
            }
        }
        return false;
    }
}

