/*
 * Decompiled with CFR 0.152.
 */
package org.notima.util;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarUtil {
    private ClassLoader classLoader;

    public JarUtil(ClassLoader cl) {
        this.classLoader = cl;
    }

    public void copyResourcesToDirectory(String sourceDir, String destinationDir) {
        block14: {
            try {
                URL resourceDirURL = this.classLoader.getResource(sourceDir);
                if (resourceDirURL == null) {
                    throw new RuntimeException("Resource directory not found: " + sourceDir);
                }
                URI resourceDirURI = resourceDirURL.toURI();
                if ("jar".equals(resourceDirURI.getScheme())) {
                    JarURLConnection connection = (JarURLConnection)resourceDirURL.openConnection();
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (JarFile jarFile = connection.getJarFile();){
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.isDirectory() || !entry.getName().startsWith(sourceDir)) continue;
                            Path destination = Paths.get(destinationDir, entry.getName().substring(sourceDir.length()));
                            Files.copy(jarFile.getInputStream(entry), destination, StandardCopyOption.REPLACE_EXISTING);
                        }
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                Files.walk(Paths.get(resourceDirURI), new FileVisitOption[0]).forEach(source -> {
                    try {
                        Path destination = Paths.get(destinationDir, Paths.get(resourceDirURI).relativize((Path)source).toString());
                        Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

