/*
 * Decompiled with CFR 0.152.
 */
package org.notima.util;

import java.text.DateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class LocalDateUtils {
    public static Date asDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static String getDateRangeStr(Date startDate, Date endDate, DateFormat dtf, String rangeSeparator) {
        if (dtf == null) {
            dtf = DateFormat.getDateInstance(3);
        }
        if (rangeSeparator == null) {
            rangeSeparator = "_";
        }
        StringBuffer buf = new StringBuffer();
        if (startDate == null && endDate != null) {
            startDate = endDate;
        }
        if (endDate == null && startDate != null) {
            endDate = startDate;
        }
        if (startDate == null && endDate == null) {
            return "";
        }
        if (startDate.equals(endDate)) {
            buf.append(dtf.format(startDate));
        } else {
            buf.append(dtf.format(startDate) + rangeSeparator + dtf.format(endDate));
        }
        return buf.toString();
    }
}

