/*
 * Decompiled with CFR 0.152.
 */
package org.notima.util;

import java.util.Calendar;
import java.util.Date;

public class NotimaUtil {
    public static String toDigitsOnly(String cleanUp) {
        if (cleanUp == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cleanUp.length()) {
            char c = cleanUp.charAt(i);
            if (c >= '0' && c <= '9') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean hasDigitsOnly(String ref) {
        if (ref == null || ref.trim().length() == 0) {
            return false;
        }
        int i = 0;
        while (i < ref.length()) {
            char c = ref.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String removeBlanks(String cleanUp) {
        if (cleanUp == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < cleanUp.length()) {
            char c = cleanUp.charAt(i);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String trimLeadingZeros(String cleanUp) {
        if (cleanUp == null) {
            return "";
        }
        if ((cleanUp = cleanUp.trim()).length() == 0) {
            return "";
        }
        int i = 0;
        while (i < cleanUp.length() && cleanUp.charAt(i) == '0') {
            ++i;
        }
        return cleanUp.substring(i);
    }

    public static boolean validateIban(String swift, String iban) {
        boolean pass = false;
        if (swift != null && swift.trim().length() > 0 && iban != null && iban.trim().length() > 0) {
            pass = true;
        }
        return pass;
    }

    public static boolean validateBankgiro(String Bankgiro) {
        int length = NotimaUtil.toDigitsOnly(Bankgiro).length();
        return length > 0 && length < 10;
    }

    public static String getAmountStr(double amount) {
        return NotimaUtil.getAmountStr(amount, 12, true);
    }

    public static String getAmountStr(double amount, int len, boolean absolute) {
        StringBuffer buf = new StringBuffer();
        long newAmount = Math.round(Math.abs(amount) * 100.0);
        buf.append(Long.toString(newAmount));
        while (buf.length() < len) {
            buf.insert(0, "0");
        }
        if (amount < 0.0 && !absolute) {
            char lastDigit = buf.charAt(buf.length() - 1);
            buf.replace(buf.length() - 1, buf.length(), switch (lastDigit) {
                case '0' -> "-";
                case '1' -> "J";
                case '2' -> "K";
                case '3' -> "L";
                case '4' -> "M";
                case '5' -> "N";
                case '6' -> "O";
                case '7' -> "P";
                case '8' -> "Q";
                case '9' -> "R";
                default -> "E";
            });
        }
        return buf.toString();
    }

    public static double parseAmountStr(String amountStr) {
        Double amount = Double.parseDouble(amountStr);
        amount = amount / 100.0;
        return amount;
    }

    public static int getLuhnDigit(double amount) {
        String amountStr = NotimaUtil.trimLeadingZeros(NotimaUtil.getAmountStr(amount, 20, true));
        return NotimaUtil.getLuhnDigit(amountStr);
    }

    public static int getLuhnDigit(String indata) {
        int a = 2;
        int sum = 0;
        int i = indata.length() - 1;
        while (i >= 0) {
            int term = Character.digit(indata.charAt(i), 10) * a;
            if (term > 9) {
                term -= 9;
            }
            sum += term;
            a = 3 - a;
            --i;
        }
        int tens = sum / 10 * 10;
        int subtractfrom = tens + 10;
        return (subtractfrom - sum) % 10;
    }

    public static String toOCRNumber(String indata) {
        indata = NotimaUtil.toDigitsOnly(indata);
        return indata + NotimaUtil.getLuhnDigit(indata);
    }

    public static String toOCRNumberWithLengthCheck(String indata) {
        indata = NotimaUtil.toDigitsOnly(indata);
        int length = indata.length() + 2;
        String ocrCode = indata + (length %= 10);
        return ocrCode + NotimaUtil.getLuhnDigit(ocrCode);
    }

    public static boolean isValidOCRNumber(String OCR) {
        if (OCR == null || OCR.length() == 0) {
            return false;
        }
        String ccNumber1 = NotimaUtil.toDigitsOnly(OCR);
        int ccLength = ccNumber1.length();
        StringBuffer buf = new StringBuffer();
        int i = ccLength;
        while (i != 0) {
            buf.append(ccNumber1.charAt(i - 1));
            --i;
        }
        String ccNumber = buf.toString();
        int sum = 0;
        int i2 = 0;
        while (i2 < ccLength) {
            int digit = Character.getNumericValue(ccNumber.charAt(i2));
            if (i2 % 2 == 1 && (digit *= 2) > 9) {
                digit -= 9;
            }
            sum += digit;
            ++i2;
        }
        return sum % 10 == 0;
    }

    public static String fillToLength(String str, boolean rightAlign, char fillChar, int len) {
        if (str == null) {
            str = "";
        }
        StringBuffer buf = new StringBuffer();
        if (str.length() > len) {
            if (rightAlign) {
                buf.append(str.substring(str.length() - len, str.length()));
            } else {
                buf.append(str.substring(0, len));
            }
            return buf.toString();
        }
        buf.append(str);
        while (buf.length() < len) {
            if (rightAlign) {
                buf.insert(0, fillChar);
                continue;
            }
            buf.append(fillChar);
        }
        return buf.toString();
    }

    public static String onlyUSASCII(String clearupstring) {
        if (clearupstring == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        String work = clearupstring.toUpperCase();
        int i = 0;
        while (i < work.length()) {
            char c = work.charAt(i);
            if (c == '\u00c5' || c == '\u00c4') {
                buf.append("A");
            } else if (c == '\u00d6') {
                buf.append("O");
            } else if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == ',' || c == '.' || c == '-') {
                buf.append(c);
            } else {
                buf.append(" ");
            }
            ++i;
        }
        return buf.toString();
    }

    public static int daysFromNow(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 12);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        long then = date.getTime();
        Calendar nowCal = Calendar.getInstance();
        nowCal.set(11, 0);
        nowCal.set(12, 0);
        nowCal.set(13, 0);
        nowCal.set(14, 0);
        long now = nowCal.getTimeInMillis();
        long daysInMillis = then - now;
        long days = daysInMillis / 1000L / 60L / 60L / 24L;
        return (int)days;
    }

    public static Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }
}

