/*
 * Decompiled with CFR 0.152.
 */
package org.notima.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.util.InvalidTaxIdFormatException;
import org.notima.util.TaxIdStructure;
import org.notima.util.UnknownTaxIdFormatException;

public class TaxIdFormatter {
    private static Pattern se10 = Pattern.compile("^(\\d{2})(\\d{2})(\\d{2})(\\d{4})$");
    private static Pattern se11 = Pattern.compile("^(\\d{2})(\\d{2})(\\d{2})\\-(\\d{4})$");
    private static Pattern se12 = Pattern.compile("^(\\d{4})(\\d{2})(\\d{2})(\\d{4})$");
    private static Pattern se14 = Pattern.compile("^SE(\\d{2})(\\d{2})(\\d{2})(\\d{4})01$");

    public static String toDigitsOnly(String cleanUp) {
        if (cleanUp == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cleanUp.length()) {
            char c = cleanUp.charAt(i);
            if (c >= '0' && c <= '9') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean hasDigitsOnly(String ref) {
        if (ref == null || ref.trim().length() == 0) {
            return false;
        }
        int i = 0;
        while (i < ref.length()) {
            char c = ref.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String removeBlanks(String cleanUp) {
        if (cleanUp == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < cleanUp.length()) {
            char c = cleanUp.charAt(i);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String printTaxId(String srcFormat, String taxId, String dstFormat) throws UnknownTaxIdFormatException, InvalidTaxIdFormatException {
        Matcher m;
        if (dstFormat == null) {
            throw new UnknownTaxIdFormatException("Destination format can't be null.");
        }
        if (srcFormat == null || srcFormat.trim().length() == 0) {
            srcFormat = TaxIdFormatter.determineFormat(null, taxId);
        }
        if (srcFormat == null || srcFormat.equals(TaxIdStructure.FMT_UNKNOWN)) {
            throw new UnknownTaxIdFormatException("Source format: " + srcFormat);
        }
        TaxIdStructure t = null;
        if (TaxIdStructure.FMT_SE10.equalsIgnoreCase(srcFormat)) {
            m = se10.matcher(taxId);
        } else if (TaxIdStructure.FMT_SE11.equalsIgnoreCase(srcFormat)) {
            m = se11.matcher(taxId);
        } else if (TaxIdStructure.FMT_SE12.equalsIgnoreCase(srcFormat)) {
            m = se12.matcher(taxId);
        } else if (TaxIdStructure.FMT_SE14.equalsIgnoreCase(srcFormat)) {
            m = se14.matcher(taxId);
        } else {
            throw new UnknownTaxIdFormatException("Source format: " + srcFormat);
        }
        if (!m.matches()) {
            throw new InvalidTaxIdFormatException("Taxid " + taxId + " doesn't conform to source format " + srcFormat + ".");
        }
        t = TaxIdFormatter.createTaxIdStructureFromMatcher(m, srcFormat);
        return t.printTaxId(dstFormat);
    }

    private static TaxIdStructure createTaxIdStructureFromMatcher(Matcher m, String taxIdFormat) {
        TaxIdStructure t = new TaxIdStructure(taxIdFormat);
        t.setPrefix(m.group(1));
        t.setLeftmiddle(m.group(2));
        t.setRightmiddle(m.group(3));
        t.setSuffix(m.group(4));
        return t;
    }

    public static String determineFormat(String countryCode, String taxId) {
        if (taxId == null) {
            return TaxIdStructure.FMT_UNKNOWN;
        }
        if (countryCode == null || countryCode.trim().length() == 0 || "SE".equalsIgnoreCase(countryCode)) {
            Matcher m10 = se10.matcher(taxId);
            if (m10.matches()) {
                return TaxIdStructure.FMT_SE10;
            }
            Matcher m11 = se11.matcher(taxId);
            if (m11.matches()) {
                return TaxIdStructure.FMT_SE11;
            }
            Matcher m12 = se12.matcher(taxId);
            if (m12.matches()) {
                return TaxIdStructure.FMT_SE12;
            }
            Matcher m14 = se14.matcher(taxId);
            if (m14.matches()) {
                return TaxIdStructure.FMT_SE14;
            }
        }
        return TaxIdStructure.FMT_UNKNOWN;
    }
}

