/*
 * Decompiled with CFR 0.152.
 */
package org.notima.util.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import org.notima.util.json.JsonLocalDateAdapter;

public class JsonUtil {
    private GsonBuilder gsonBuilder;
    private Gson gson;
    private final String dfmtStr = "yyyy-MM-dd";
    private DateFormat dfmt = new SimpleDateFormat("yyyy-MM-dd");
    private final String shortdfmtStr = "yyMMdd";
    private DateFormat shortdfmt = new SimpleDateFormat("yyMMdd");

    private void initDefaultGson() {
        this.initDefaultGsonBuilder();
        this.gson = this.gsonBuilder.create();
    }

    private void initDefaultGsonBuilder() {
        this.gsonBuilder = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd");
        this.gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.IDENTITY);
        this.gsonBuilder.setLenient();
        this.gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new JsonLocalDateAdapter());
    }

    public static DateFormat getDateFormat() {
        JsonUtil j = new JsonUtil();
        return j.dfmt;
    }

    public static DateFormat getShortDateFormat() {
        JsonUtil j = new JsonUtil();
        return j.shortdfmt;
    }

    public Gson getDefaultGson() {
        if (this.gson == null) {
            this.initDefaultGson();
        }
        return this.gson;
    }

    public Gson getGsonWithExclusionStrategyForEntities() {
        this.initDefaultGsonBuilder();
        ExclusionStrategy strategy = new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                if (f == null || f.getName() == null) {
                    return true;
                }
                return f.getName().startsWith("_");
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        };
        this.gsonBuilder.addSerializationExclusionStrategy(strategy);
        return this.gsonBuilder.create();
    }

    public Gson getGsonWithInterfaceAdapterFor(Type typeOfClass, Object adapter) {
        this.initDefaultGsonBuilder();
        this.gsonBuilder.registerTypeAdapter(typeOfClass, adapter);
        return this.gsonBuilder.create();
    }

    public static Gson buildGson() {
        JsonUtil j = new JsonUtil();
        return j.getDefaultGson();
    }
}

