/*
 * Decompiled with CFR 0.152.
 */
package org.notima.swish;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.notima.swish.PaymentRequest;
import org.notima.swish.SwishException;
import org.notima.swish.SwishPayment;
import org.notima.swish.SwishResponseHeaders;
import sun.net.www.protocol.https.Handler;

public class SwishClient {
    private final String BASE_URL_PRODUCTION = "https://cpc.getswish.net/swish-cpcapi";
    private final String BASE_URL_TEST = "https://mss.cpc.getswish.net/swish-cpcapi";
    private final String URL_PAYMENTREQUESTS = "/api/v2/paymentrequests/";
    private boolean test = false;
    private KeyStore keyStore;
    private String keyStorePassword;
    private KeyStore trustStore;
    private KeyManagerFactory keyStoreManagerFactory;
    private TrustManagerFactory trustStoreManagerFactory;
    private Gson gson;

    public static String generateInstructionUUID() {
        Random r = new Random();
        StringBuffer sb = new StringBuffer();
        while (sb.length() < 32) {
            sb.append(Integer.toHexString(r.nextInt()));
        }
        return sb.toString().substring(0, 32).toUpperCase();
    }

    public SwishClient(KeyStore keyStore, String keyStorePassword, KeyStore trustStore) throws SwishException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, IOException {
        this(false, keyStore, keyStorePassword, trustStore);
    }

    public SwishClient(boolean test, KeyStore keyStore, String keyStorePassword, KeyStore trustStore) throws SwishException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, IOException {
        this.test = test;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = trustStore;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.initKeyStores();
    }

    private void initKeyStores() throws UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, IOException {
        this.keyStoreManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.keyStoreManagerFactory.init(this.keyStore, this.keyStorePassword.toCharArray());
        this.trustStoreManagerFactory = TrustManagerFactory.getInstance("SunX509");
        this.trustStoreManagerFactory.init(this.trustStore);
    }

    public SwishResponseHeaders sendPaymentRequest(PaymentRequest request, String instructionUUID) throws SwishException {
        SSLSocketFactory defaultSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        SwishResponseHeaders responseHeaders = null;
        try {
            URL url = new URL(null, String.valueOf(this.getBaseUrl()) + "/api/v2/paymentrequests/" + instructionUUID, new Handler());
            String paymentRequestJson = this.gson.toJson((Object)request);
            HttpsURLConnection conn = this.openConnection(url, "PUT");
            this.addBodyToConnection(conn, paymentRequestJson);
            int responseCode = conn.getResponseCode();
            if (responseCode != 201) {
                HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
                conn.disconnect();
                throw new SwishException(String.format("Response from %s:\n%s", url.toString(), this.getErrorBodyFromConnection(conn)));
            }
            responseHeaders = this.getResponseHeaders(conn);
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
            conn.disconnect();
            return responseHeaders;
        }
        catch (Exception e) {
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
            throw new SwishException("Payment request failed", e);
        }
    }

    private SwishResponseHeaders getResponseHeaders(HttpsURLConnection conn) {
        Map<String, List<String>> hdrs = conn.getHeaderFields();
        String location = hdrs.get("Location").get(0);
        String requestToken = null;
        if (hdrs.get("PaymentRequestToken") != null) {
            requestToken = hdrs.get("PaymentRequestToken").get(0);
        }
        return new SwishResponseHeaders(location, requestToken);
    }

    private String getBaseUrl() {
        String url = this.test ? "https://mss.cpc.getswish.net/swish-cpcapi" : "https://cpc.getswish.net/swish-cpcapi";
        return url;
    }

    public SwishPayment retrievePayment(String url) throws SwishException, MalformedURLException {
        return this.retrievePayment(new URL(url));
    }

    public SwishPayment retrievePayment(URL url) throws SwishException {
        SSLSocketFactory defaultSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(this.getSSLContext().getSocketFactory());
            HttpsURLConnection conn = this.openConnection(url, "GET");
            String body = this.getBodyFromConnection(conn);
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
            return (SwishPayment)this.gson.fromJson(body, SwishPayment.class);
        }
        catch (Exception e) {
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
            throw new SwishException("", e);
        }
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslctx = SSLContext.getInstance("TLSv1.2");
        sslctx.init(this.keyStoreManagerFactory.getKeyManagers(), this.trustStoreManagerFactory.getTrustManagers(), null);
        return sslctx;
    }

    private HttpsURLConnection openConnection(URL url, String method) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setInstanceFollowRedirects(true);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setUseCaches(false);
        return conn;
    }

    private void addBodyToConnection(HttpsURLConnection conn, String body) throws IOException {
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(body);
        wr.flush();
        wr.close();
    }

    private String getBodyFromConnection(HttpsURLConnection conn) throws IOException {
        String currentLine;
        if (conn.getResponseCode() / 100 != 2) {
            return null;
        }
        InputStream stream = conn.getInputStream();
        InputStreamReader streamReader = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(streamReader);
        StringBuilder response = new StringBuilder();
        while ((currentLine = reader.readLine()) != null) {
            response.append(currentLine);
        }
        reader.close();
        return response.toString();
    }

    private String getErrorBodyFromConnection(HttpsURLConnection conn) {
        InputStream stream = conn.getErrorStream();
        if (stream == null) {
            return "";
        }
        Scanner scanner = new Scanner(stream, "UTF-8");
        String errorString = scanner.useDelimiter("\\A").next();
        scanner.close();
        return errorString;
    }
}

