/*
 * Decompiled with CFR 0.152.
 */
package org.notima.swish.reports;

import java.beans.Transient;
import java.util.Date;
import java.util.List;
import org.notima.swish.reports.SettlementReportRow;

public class SettlementReport {
    private String clearingNumber;
    private String accountNumber;
    private List<SettlementReportRow> rows;

    public String getClearingNumber() {
        return this.clearingNumber;
    }

    public void setClearingNumber(String clearingNumber) {
        this.clearingNumber = clearingNumber;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public List<SettlementReportRow> getRows() {
        return this.rows;
    }

    public void setRows(List<SettlementReportRow> rows) {
        this.rows = rows;
    }

    @Transient
    public boolean hasRows() {
        return this.rows != null && !this.rows.isEmpty();
    }

    @Transient
    public Date getFirstBookkeepingDate() {
        if (!this.hasRows()) {
            return null;
        }
        Date firstDate = new Date(Long.MAX_VALUE);
        for (SettlementReportRow r : this.rows) {
            if (r.getBookKeepingDate() == null || !r.getBookKeepingDate().before(firstDate)) continue;
            firstDate = r.getBookKeepingDate();
        }
        return firstDate;
    }

    @Transient
    public Date getLastBookkeepingDate() {
        if (!this.hasRows()) {
            return null;
        }
        Date lastDate = new Date(0L);
        for (SettlementReportRow r : this.rows) {
            if (r.getBookKeepingDate() == null || !r.getBookKeepingDate().after(lastDate)) continue;
            lastDate = r.getBookKeepingDate();
        }
        return lastDate;
    }

    @Transient
    public Date getFirstTransactionDate() {
        if (!this.hasRows()) {
            return null;
        }
        Date firstDate = new Date(Long.MAX_VALUE);
        for (SettlementReportRow r : this.rows) {
            if (!r.getTransactionDate().before(firstDate)) continue;
            firstDate = r.getTransactionDate();
        }
        return firstDate;
    }

    @Transient
    public Date getLastTransactionDate() {
        if (!this.hasRows()) {
            return null;
        }
        Date lastDate = new Date(0L);
        for (SettlementReportRow r : this.rows) {
            if (!r.getTransactionDate().after(lastDate)) continue;
            lastDate = r.getTransactionDate();
        }
        return lastDate;
    }
}

