/*
 * Decompiled with CFR 0.152.
 */
package org.nwolfhub.easycli.model;

public class Border {
    public String upChar;
    public String downChar;
    public String midChar;

    public Border() {
    }

    public Border(String upChar, String downChar, String midChar) {
        this.upChar = upChar;
        this.downChar = downChar;
        this.midChar = midChar;
    }

    public String getUpChar() {
        return this.upChar;
    }

    public Border setUpChar(String upChar) {
        this.upChar = upChar;
        return this;
    }

    public String getDownChar() {
        return this.downChar;
    }

    public Border setDownChar(String downChar) {
        this.downChar = downChar;
        return this;
    }

    public String getMidChar() {
        return this.midChar;
    }

    public Border setMidChar(String midChar) {
        this.midChar = midChar;
        return this;
    }

    private int findMax(String[] text) {
        int max = 0;
        for (String line : text) {
            max = Math.max(line.length(), max);
        }
        return max;
    }

    public String applyBorder(String[] text) {
        int maxTextLength = this.findMax(text);
        StringBuilder builder = new StringBuilder();
        builder.append(" ");
        builder.append(this.upChar.repeat(maxTextLength));
        builder.append("\n");
        for (String line : text) {
            builder.append(this.midChar);
            builder.append(line);
            builder.append(" ".repeat(maxTextLength - line.length()));
            builder.append(this.midChar);
            builder.append("\n");
        }
        builder.append(" ").append(this.downChar.repeat(maxTextLength)).append("\n");
        return builder.toString();
    }

    public String applyBorder(String text) {
        return this.applyBorder(text.split("\n"));
    }
}

