/*
 * Decompiled with CFR 0.152.
 */
package org.nwolfhub.easycli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.nwolfhub.easycli.Defaults;
import org.nwolfhub.easycli.VariableProcessor;
import org.nwolfhub.easycli.model.InputTask;
import org.nwolfhub.easycli.model.Level;
import org.nwolfhub.easycli.model.Template;
import org.nwolfhub.easycli.model.Variable;
import org.nwolfhub.utils.Configurator;

public class EasyCLI {
    private HashMap<String, Template> templates = new HashMap();
    private HashMap<String, InputTask> tasks = new HashMap();
    public String activeTemplate;
    private ExecutorService executor = Executors.newFixedThreadPool(1);
    private InputStream in;
    private PrintStream out;
    private final VariableProcessor variableProcessor = new VariableProcessor();
    public Level level = Level.Warn;
    public String commandNotFoundText = "Command {command} not found";
    public Boolean printNotFoundText = true;

    private void listenOnStream() {
        Scanner sc = new Scanner(this.in);
        int errorCounter = 0;
        while (true) {
            block10: {
                try {
                    String inp = sc.nextLine();
                    if (inp.equals("")) break block10;
                    String command = inp.split(" ")[0];
                    if (!this.tasks.containsKey(command)) {
                        if (this.printNotFoundText.booleanValue()) {
                            this.print(this.commandNotFoundText.replace("{command }", command));
                        }
                        break block10;
                    }
                    List<Object> args = new ArrayList();
                    try {
                        args = List.of(inp.substring(command.length() + 1).split(" "));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String[] argArr = args.toArray(new String[0]);
                    this.tasks.get(command).act(this, argArr);
                }
                catch (NoSuchElementException e) {
                    ++errorCounter;
                }
                catch (Exception e) {
                    ++errorCounter;
                    e.printStackTrace();
                }
            }
            if (errorCounter <= 10) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            errorCounter = 0;
        }
    }

    public EasyCLI(InputStream in, PrintStream out) {
        this.in = in;
        this.out = out;
    }

    public EasyCLI() {
        this.in = System.in;
        this.out = System.out;
    }

    public EasyCLI(boolean overrideStreams) {
        this.in = System.in;
        this.out = System.out;
        if (overrideStreams) {
            System.setIn(new InputStream(){

                @Override
                public int read() {
                    return 0;
                }
            });
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }));
        }
    }

    public void stopListening() {
        this.executor.shutdownNow();
    }

    public void startListening() {
        this.executor.shutdownNow();
        this.executor = Executors.newFixedThreadPool(1);
        this.executor.submit(new Thread(this::listenOnStream));
    }

    public void addTemplate(Template template) {
        this.templates.put(template.getName(), template);
    }

    public void addTemplate(Template template, String name) {
        this.templates.put(name, template);
    }

    public void addTemplate(String name, Template template) {
        this.templates.put(name, template);
    }

    public void removeTemplate(String name) {
        this.templates.remove(name);
    }

    public List<Template> getTemplates() {
        return new ArrayList<Template>(this.templates.values());
    }

    public void addTask(String command, InputTask task) {
        this.tasks.put(command, task);
    }

    public void removeTask(String command) {
        this.tasks.remove(command);
    }

    public List<InputTask> getTasks() {
        return new ArrayList<InputTask>(this.tasks.values());
    }

    public String getActiveTemplate() {
        return this.activeTemplate;
    }

    public EasyCLI setActiveTemplate(String activeTemplate) {
        this.activeTemplate = activeTemplate;
        return this;
    }

    public Level getLevel() {
        return this.level;
    }

    public EasyCLI setLevel(Level level) {
        this.level = level;
        return this;
    }

    public void detectLogLevel() throws IOException {
        Level level = this.detectLogLevelInConfig(new File("easycli.cfg"));
        if (level == null) {
            level = this.detectLogLevelInProperties();
            if (level == null) {
                throw new IOException("Could not detect cli-log-level variable in both easycli.cfg and application.properties");
            }
            this.level = level;
        } else {
            this.level = level;
        }
    }

    public void detectLogLevel(File file) throws IOException {
        Level level = this.detectLogLevelInConfig(file);
        if (level == null) {
            throw new IOException("Could not detect log level in provided file");
        }
        this.level = level;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Level detectLogLevelInProperties() {
        try {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            ClassLoader loader = trace[2].getClass().getClassLoader();
            try (InputStream stream = loader.getResourceAsStream("application.properties");){
                Properties properties = new Properties();
                properties.load(stream);
                if (!properties.containsKey("cli-log-level")) return null;
                Level level = Level.valueOf(IntStream.range(0, properties.get("cli-log-level").toString().split("").length).mapToObj(i -> {
                    if (i == 0) {
                        return properties.get("cli-log-level").toString().split("")[i].toUpperCase();
                    }
                    return properties.get("cli-log-level").toString().split("")[i];
                }).collect(Collectors.joining()));
                return level;
            }
            catch (IOException e) {
                if (trace.length <= 3) return null;
                loader = trace[trace.length - 1].getClass().getClassLoader();
                try (InputStream stream2 = loader.getResourceAsStream("application.properties");){
                    Properties properties = new Properties();
                    properties.load(stream2);
                    if (!properties.containsKey("cli-log-level")) return null;
                    Level level = Level.valueOf(IntStream.range(0, properties.get("cli-log-level").toString().split("").length).mapToObj(i -> {
                        if (i == 0) {
                            return properties.get("cli-log-level").toString().split("")[i].toUpperCase();
                        }
                        return properties.get("cli-log-level").toString().split("")[i];
                    }).collect(Collectors.joining()));
                    return level;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Level detectLogLevelInConfig(File configFile) {
        try {
            Configurator configurator = new Configurator(configFile);
            if (configurator.containsKey("cli-log-level")) {
                return Level.valueOf(configurator.getValue("cli-log-level"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void setTemplateIfNone() {
        if (this.templates.isEmpty()) {
            this.templates.put("default", Defaults.defaultTemplate);
        }
        if (this.activeTemplate == null) {
            this.activeTemplate = new ArrayList<Template>(this.templates.values()).get(this.templates.size() - 1).getName();
        }
    }

    public void print(String text, String template) {
        this.printInternal(text, this.templates.get(template));
    }

    public void print(String text, Template template) {
        this.printInternal(text, template);
    }

    public void print(String text) {
        this.setTemplateIfNone();
        this.printInternal(text, this.templates.get(this.activeTemplate));
    }

    public void print(Object ... objects) {
        this.setTemplateIfNone();
        this.printInternal(String.join((CharSequence)" ", Arrays.stream(objects).map(Object::toString).collect(Collectors.joining())), this.templates.get(this.activeTemplate));
    }

    public void print(Template template, Object ... objects) {
        this.printInternal(String.join((CharSequence)" ", Arrays.stream(objects).map(Object::toString).collect(Collectors.joining())), template);
    }

    public void print(String template, Object ... objects) {
        this.printInternal(String.join((CharSequence)" ", Arrays.stream(objects).map(Object::toString).collect(Collectors.joining())), this.templates.get(template));
    }

    public void print(Class<?> template, String text) {
        this.setTemplateIfNone();
        this.printInternal(text, this.templates.values().stream().filter(e -> e.getClass().equals(template)).findFirst().orElse(this.templates.get(this.activeTemplate)));
    }

    public void print(String text, Class<?> template) {
        this.setTemplateIfNone();
        this.printInternal(text, this.templates.values().stream().filter(e -> e.getClass().equals(template)).findFirst().orElse(this.templates.get(this.activeTemplate)));
    }

    public void printAtLevel(String text, String template, Level level) {
        this.printInternal(text, this.templates.get(template), level);
    }

    public void printAtLevel(String text, Template template, Level level) {
        this.printInternal(text, template, level);
    }

    public void printAtLevel(String text, Level level) {
        this.setTemplateIfNone();
        this.printInternal(text, this.templates.get(this.activeTemplate), level);
    }

    public void printAtLevel(Level level, Object ... objects) {
        this.setTemplateIfNone();
        this.printInternal(String.join((CharSequence)" ", Arrays.stream(objects).map(Object::toString).collect(Collectors.joining())), this.templates.get(this.activeTemplate), level);
    }

    public void printAtLevel(Template template, Level level, Object ... objects) {
        this.printInternal(String.join((CharSequence)" ", Arrays.stream(objects).map(Object::toString).collect(Collectors.joining())), template, level);
    }

    public void printAtLevel(String template, Level level, Object ... objects) {
        this.printInternal(String.join((CharSequence)" ", Arrays.stream(objects).map(Object::toString).collect(Collectors.joining())), this.templates.get(template), level);
    }

    public void printAtLevel(Class<?> template, Level level, String text) {
        this.setTemplateIfNone();
        this.printInternal(text, this.templates.values().stream().filter(e -> e.getClass().equals(template)).findFirst().orElse(this.templates.get(this.activeTemplate)), level);
    }

    public void printAtLevel(String text, Level level, Class<?> template) {
        this.setTemplateIfNone();
        this.printInternal(text, this.templates.values().stream().filter(e -> e.getClass().equals(template)).findFirst().orElse(this.templates.get(this.activeTemplate)), level);
    }

    public void addVariable(Variable v) {
        this.variableProcessor.addVariable(v);
    }

    public void removeVariable(int index) {
        this.variableProcessor.removeVariable(index);
    }

    public void clearVariables() {
        this.variableProcessor.clearAll();
    }

    public List<Variable> getVariables() {
        return this.variableProcessor.getVariables();
    }

    private void printInternal(String text, Template template, Level level) {
        if (level.ordinal() >= this.level.ordinal()) {
            this.out.print(template.formatText(this.variableProcessor.processText(text), level));
        }
        if (level == Level.Panic) {
            System.exit(1);
        }
    }

    private void printInternal(String text, Template template) {
        this.printInternal(text, template, this.level);
    }
}

