/*
 * Decompiled with CFR 0.152.
 */
package org.nwolfhub.easycli.model;

import java.util.List;
import java.util.Locale;
import org.nwolfhub.easycli.VariableProcessor;
import org.nwolfhub.easycli.model.Border;
import org.nwolfhub.easycli.model.Level;
import org.nwolfhub.easycli.model.Variable;

public class Template {
    public String name;
    public String prefix;
    public String postfix;
    public Border border;
    private final VariableProcessor processor = new VariableProcessor();

    public Template() {
    }

    public Template(String name, String prefix, String postfix) {
        this.name = name;
        this.prefix = prefix;
        this.postfix = postfix;
    }

    public String getName() {
        return this.name;
    }

    public Template setName(String name) {
        this.name = name;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Template setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public Template setPostfix(String postfix) {
        this.postfix = postfix;
        return this;
    }

    public Border getBorder() {
        return this.border;
    }

    public Template setBorder(Border border) {
        this.border = border;
        return this;
    }

    public String formatText(String text, Level level) {
        text = this.processor.processText(this.prefix.replace("{logLevel}", level.toString().toUpperCase(Locale.ROOT)) + text + this.postfix);
        return this.border == null ? text : this.border.applyBorder(text);
    }

    public Template addVariable(Variable v) {
        this.processor.addVariable(v);
        return this;
    }

    public Template removeVariable(int index) {
        this.processor.removeVariable(index);
        return this;
    }

    public Template clearVariables() {
        this.processor.clearAll();
        return this;
    }

    public List<Variable> getVariables() {
        return this.processor.getVariables();
    }
}

