/*
 * Decompiled with CFR 0.152.
 */
package org.nwolfhub.shared.database;

import java.util.Map;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.nwolfhub.shared.database.model.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HibernateController {
    private SessionFactory sessionFactory;
    @Autowired
    private Properties properties;

    public HibernateController(Properties properties) {
        this.properties = properties;
    }

    public SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            try {
                Configuration configuration = new Configuration();
                configuration.addAnnotatedClass(User.class);
                configuration.setProperties(this.properties);
                StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties());
                this.sessionFactory = configuration.buildSessionFactory((ServiceRegistry)builder.build());
            }
            catch (Exception e) {
                System.out.println("Exception: ");
                e.printStackTrace();
            }
        }
        return this.sessionFactory;
    }
}

