/*
 * Decompiled with CFR 0.152.
 */
package org.nwolfhub.utils;

import jakarta.xml.bind.DatatypeConverter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Random;

public class Utils {
    public static Random random = new Random();
    public static String[] characters;

    public static String generateString(int length) {
        StringBuilder result = new StringBuilder();
        for (int now = 0; now < length; ++now) {
            result.append(characters[random.nextInt(characters.length)]);
        }
        return result.toString();
    }

    public static HashMap<String, String> parseValues(String[] text) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String record : text) {
            if (record.split("")[0].equals("#") || !record.contains("=")) continue;
            map.put(record.split("=")[0], record.split("=")[1]);
        }
        return map;
    }

    public static HashMap<String, String> parseValues(String text, String separator) {
        return Utils.parseValues(text.split(separator));
    }

    public static String buildConnectionString(String address, Integer port, String database) {
        return "jdbc:postgresql://" + address + ":" + port + "/" + database;
    }

    public static String buildConnectionString(String driver, String address, Integer port, String database) {
        return "jdbc: " + driver + "://" + address + ":" + port + "/" + database;
    }

    public static String hashString(String text, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        return DatatypeConverter.printBase64Binary((byte[])digest.digest(text.getBytes()));
    }

    public static String hashString(String text) throws NoSuchAlgorithmException {
        return Utils.hashString(text, "SHA-256");
    }

    static {
        Object charS = "abcdefghijklmnopqrstuvwxyz";
        charS = (String)charS + ((String)charS).toUpperCase() + "01234567890";
        characters = ((String)charS).split("");
    }
}

