/*
 * Decompiled with CFR 0.152.
 */
package org.nwolfhub.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.nwolfhub.easycli.EasyCLI;
import org.nwolfhub.utils.Utils;

public class Configurator {
    private HashMap<String, String> parsed;
    private String raw;
    private EasyCLI cli;
    public File configFile = new File("config.cfg");

    public Configurator() {
    }

    public Configurator(boolean useEasyCLI) {
        if (useEasyCLI) {
            this.cli = new EasyCLI();
        }
        this.readConfig();
    }

    public Configurator(EasyCLI cli) {
        this.cli = new EasyCLI();
        this.readConfig();
    }

    public Configurator(File configFile, String defaultConfig) {
        this.configFile = configFile;
        try {
            this.createConfigIfNotExists(defaultConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.readConfig();
    }

    public Configurator(File configFile) {
        this.configFile = configFile;
        this.readConfig();
    }

    public Configurator(EasyCLI cli, File configFile) {
        this.cli = cli;
        this.configFile = configFile;
        this.readConfig();
    }

    public Configurator(boolean useEasyCLI, File configFile) {
        if (useEasyCLI) {
            this.cli = new EasyCLI();
        }
        this.configFile = configFile;
        this.readConfig();
    }

    public String getValue(String key) {
        return this.parsed.get(key);
    }

    public String getSingleValue(String key) {
        key = key.replace("*", ".+").replace("?", ".");
        Pattern pattern = Pattern.compile(key);
        for (String keyValue : this.parsed.keySet()) {
            if (!pattern.matcher(keyValue).matches()) continue;
            return this.parsed.get(keyValue);
        }
        return null;
    }

    public List<String> getAllValues(String key) {
        key = key.replace("*", ".+").replace("?", ".");
        Pattern pattern = Pattern.compile(key);
        ArrayList<String> result = new ArrayList<String>();
        for (String keyValue : this.parsed.keySet()) {
            if (!pattern.matcher(keyValue).matches()) continue;
            result.add(this.parsed.get(keyValue));
        }
        return result;
    }

    public void reloadConfig() {
        this.readConfig();
    }

    public void createConfigIfNotExists() throws IOException {
        if (!this.configFile.exists()) {
            this.configFile.createNewFile();
        }
    }

    public void createConfigIfNotExists(String content) throws IOException {
        if (!this.configFile.exists()) {
            this.configFile.createNewFile();
            try (FileOutputStream outputStream = new FileOutputStream(this.configFile);){
                outputStream.write(content.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public boolean createConfig() throws IOException {
        if (!this.configFile.exists()) {
            this.createConfigIfNotExists();
            return false;
        }
        return true;
    }

    public boolean createConfig(String content) throws IOException {
        if (!this.configFile.exists()) {
            this.createConfigIfNotExists(content);
            return false;
        }
        return true;
    }

    private void readConfig() {
        try (FileInputStream in = new FileInputStream(this.configFile);){
            this.raw = new String(in.readAllBytes());
            this.parsed = Utils.parseValues(this.raw, "\n");
            this.print("Configuration updated");
        }
        catch (IOException e) {
            this.print("Failed to read configuration file " + this.configFile);
            throw new RuntimeException(e);
        }
    }

    public int getEntriesAmount() {
        return this.parsed.size();
    }

    private void print(String text) {
        if (this.cli != null) {
            this.cli.print(text);
        }
    }
}

