/*
 * Decompiled with CFR 0.152.
 */
package org.nwolfhub.vkUser.longpoll;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Request;
import okhttp3.Response;
import org.nwolfhub.vk.requests.Request;
import org.nwolfhub.vkUser.Vk;
import org.nwolfhub.vkUser.longpoll.updates.Update;
import org.nwolfhub.vkUser.longpoll.updates.UpdateProcessor;

public class LongPoll {
    private Vk vk;
    private String key;
    public Long ts;
    public String server;
    public Integer wait;

    public LongPoll(Vk vk) throws IOException {
        String r = vk.makeRequest(new Request("messages.getLongPollServer", "need_pts=0"));
        this.wait = 25;
        this.vk = vk;
        try {
            JsonObject jo = JsonParser.parseString((String)r).getAsJsonObject().get("response").getAsJsonObject();
            if (jo.get("failed") != null) {
                throw new IOException("Failed with code " + jo.get("failed").getAsInt());
            }
            this.key = jo.get("key").getAsString();
            this.ts = jo.get("ts").getAsLong();
            this.server = "https://" + jo.get("server").getAsString();
        }
        catch (JsonParseException e) {
            System.out.println("Failed to obtain LongPoll connection data. Object not initialized!");
            this.key = null;
            this.ts = null;
            this.server = null;
            throw new IOException();
        }
    }

    private Response getUpdatesRequest() throws IOException {
        try {
            return this.vk.client.newCall(new Request.Builder().url(this.server + "?act=a_check&key=" + this.key + "&ts=" + this.ts + "&wait=" + this.wait + "&mode=2&version=3").build()).execute();
        }
        catch (SocketTimeoutException e) {
            return null;
        }
    }

    public List<Update> getUpdates(Long ts) throws IOException {
        ArrayList<Update> updates = new ArrayList<Update>();
        this.ts = ts;
        Response resp = this.getUpdatesRequest();
        if (resp != null) {
            JsonObject getUpdates = JsonParser.parseString((String)resp.body().string()).getAsJsonObject();
            if (getUpdates.get("failed") == null) {
                this.ts = getUpdates.get("ts").getAsInt();
                JsonArray jArr = getUpdates.getAsJsonArray("updates");
                for (JsonElement updateArr : jArr) {
                    updates.add(UpdateProcessor.convertUpdateByType(updateArr.toString()));
                }
                return updates;
            }
            String r = this.vk.makeRequest(new Request("messages.getLongPollServer", "need_pts=0"));
            JsonObject jo = JsonParser.parseString((String)r).getAsJsonObject().get("response").getAsJsonObject();
            if (jo.get("failed") != null) {
                throw new IOException("Failed with code " + jo.get("failed").getAsInt());
            }
            this.key = jo.get("key").getAsString();
            ts = jo.get("ts").getAsLong();
            this.server = "https://" + jo.get("server").getAsString();
            return new ArrayList<Update>();
        }
        return new ArrayList<Update>();
    }

    public List<Update> getUpdates() throws IOException {
        ArrayList<Update> updates = new ArrayList<Update>();
        Response resp = this.getUpdatesRequest();
        if (resp != null) {
            JsonObject getUpdates = JsonParser.parseString((String)resp.body().string()).getAsJsonObject();
            if (getUpdates.get("failed") == null) {
                this.ts = getUpdates.get("ts").getAsInt();
                JsonArray jArr = getUpdates.getAsJsonArray("updates");
                for (JsonElement updateArr : jArr) {
                    updates.add(UpdateProcessor.convertUpdateByType(updateArr.toString()));
                }
                return updates;
            }
            String r = this.vk.makeRequest(new Request("messages.getLongPollServer", "need_pts=0"));
            JsonObject jo = JsonParser.parseString((String)r).getAsJsonObject().get("response").getAsJsonObject();
            if (jo.get("failed") != null) {
                throw new IOException("Failed with code " + jo.get("failed").getAsInt());
            }
            this.key = jo.get("key").getAsString();
            this.ts = jo.get("ts").getAsLong();
            this.server = "https://" + jo.get("server").getAsString();
            return new ArrayList<Update>();
        }
        return new ArrayList<Update>();
    }

    public List<Update> getNonetypeUpdates() throws IOException {
        ArrayList<Update> updates = new ArrayList<Update>();
        JsonObject getUpdates = JsonParser.parseString((String)this.getUpdatesRequest().body().string()).getAsJsonObject();
        this.ts = getUpdates.get("ts").getAsInt();
        JsonArray jArr = getUpdates.getAsJsonArray("updates");
        for (JsonElement updateArr : jArr) {
            updates.add(new Update(updateArr.toString(), "nonetype"));
        }
        return updates;
    }

    public List<Update> getUpdatesByType(String type) throws IOException {
        List<Update> updates = this.getUpdates();
        ArrayList<Update> toReturn = new ArrayList<Update>();
        for (Update u : updates) {
            if (!u.type.equals(type)) continue;
            toReturn.add(u);
        }
        return toReturn;
    }

    public List<Update> getUpdatesByType(String type, Long ts) throws IOException {
        List<Update> updates = this.getUpdates(ts);
        ArrayList<Update> toReturn = new ArrayList<Update>();
        for (Update u : updates) {
            if (!u.type.equals(type)) continue;
            toReturn.add(u);
        }
        return toReturn;
    }

    public List<Update> getUpdatesByType(Type type, Long ts) throws IOException {
        List<Update> updates = this.getUpdates(ts);
        ArrayList<Update> toReturn = new ArrayList<Update>();
        for (Update u : updates) {
            if (!u.type.equals(type.toString())) continue;
            toReturn.add(u);
        }
        return toReturn;
    }

    public static enum Type {
        message,
        nonetype;

    }
}

