/*
 * Decompiled with CFR 0.152.
 */
package org.nwolfhub.vk.keyboard;

public class Keyboard {
    public boolean one_time;
    private boolean inline;
    public KeyboardButton[][] keyboardButtons;

    public Keyboard(boolean one_time, int sizey, int sizex) {
        this.one_time = one_time;
        this.inline = false;
        this.keyboardButtons = new KeyboardButton[sizey][sizex];
    }

    public Keyboard setInline(boolean inline) {
        this.inline = inline;
        return this;
    }

    public Keyboard addButton(KeyboardButton button, int posy, int posx) {
        this.keyboardButtons[posy][posx] = button;
        return this;
    }

    public String toString() {
        int s = 34;
        StringBuilder builder = new StringBuilder();
        if (!this.inline) {
            builder.append("{\"one_time\":").append(this.one_time);
        } else {
            builder.append("{\"inline\": ").append(true);
        }
        builder.append(",\"buttons\":[");
        for (int y = 0; y < this.keyboardButtons.length; ++y) {
            builder.append("[");
            for (int x = 0; x < this.keyboardButtons[0].length; ++x) {
                builder.append("{");
                builder.append(this.keyboardButtons[y][x].toString());
                builder.append("}");
                if (x + 1 == this.keyboardButtons[0].length) continue;
                builder.append(",");
            }
            builder.append("]");
            if (y + 1 == this.keyboardButtons.length) continue;
            builder.append(",");
        }
        builder.append("]}");
        return builder.toString();
    }

    public static class CallbackButton
    extends KeyboardButton {
        public String label;
        public String payload;

        public String getLabel() {
            return this.label;
        }

        public String getPayload() {
            return this.payload;
        }

        public CallbackButton setColor(String color) {
            this.color = color;
            return this;
        }

        public CallbackButton setPayload(String payload) {
            this.payload = payload;
            return this;
        }

        public CallbackButton setLabel(String label) {
            this.label = label;
            return this;
        }

        public CallbackButton() {
            super("text", "primary");
        }

        public CallbackButton(String label, String payload) {
            super("callback", "primary");
            this.label = label;
            this.payload = payload;
        }

        public String toString() {
            return "\"action\":{\"type\":\"callback\",\"label\":\"" + this.label + "\",\"payload\":" + this.payload + "},\"color\":\"" + this.color + "\"";
        }
    }

    public static class TextButton
    extends KeyboardButton {
        public String label;
        public String payload;

        public String getLabel() {
            return this.label;
        }

        public String getPayload() {
            return this.payload;
        }

        public TextButton setColor(String color) {
            this.color = color;
            return this;
        }

        public TextButton setColor(Color color) {
            this.color = color.name();
            return this;
        }

        public TextButton setPayload(String payload) {
            this.payload = payload;
            return this;
        }

        public TextButton setLabel(String label) {
            this.label = label;
            return this;
        }

        public TextButton() {
            super("text", "primary");
        }

        public TextButton(String label, String payload) {
            super("text", "primary");
            this.label = label;
            this.payload = payload;
        }

        public String toString() {
            if (this.payload != null) {
                return "\"action\":{\"type\":\"text\",\"label\":\"" + this.label + "\",\"payload\":" + this.payload + "},\"color\":\"" + this.color + "\"";
            }
            return "\"action\":{\"type\":\"text\",\"label\":\"" + this.label + "\"},\"color\":\"" + this.color + "\"}";
        }
    }

    private static class KeyboardButton {
        public final String type;
        public String color;

        public KeyboardButton(String type, String color) {
            this.type = type;
            this.color = color;
        }
    }

    public static enum Color {
        primary,
        secondary,
        positive,
        negative;

    }
}

