/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import edu.uiuc.ncsa.security.util.pkcs.Base64String;
import java.net.URI;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.AssetResponse;
import org.oa4mp.client.api.ClientEnvironment;
import org.oa4mp.client.api.OA4MPResponse;
import org.oa4mp.client.api.storage.AssetProvider;
import org.oa4mp.client.api.storage.AssetStore;
import org.oa4mp.client.api.storage.MemoryAssetStore;
import org.oa4mp.delegation.client.request.DelegatedAssetRequest;
import org.oa4mp.delegation.client.request.DelegatedAssetResponse;
import org.oa4mp.delegation.client.request.DelegationRequest;
import org.oa4mp.delegation.client.request.DelegationResponse;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.MyX509Certificates;

public abstract class AbstractOA4MPService {
    AssetStore assetStore;
    public static final String SKIN_PARAMETER = "skin";
    ClientEnvironment environment;
    AssetProvider assetProvider;
    protected String BASE64_URI_CAPUT = "b64:";
    long keypairExpiration = 0L;
    KeyPair keyPair = null;

    protected AssetStore getAssetStore() {
        if (this.assetStore == null) {
            this.assetStore = this.getEnvironment().hasAssetStore() ? this.getEnvironment().getAssetStore() : new MemoryAssetStore(this.getAssetProvider());
        }
        return this.assetStore;
    }

    protected AbstractOA4MPService(ClientEnvironment environment) {
        this.environment = environment;
    }

    public ClientEnvironment getEnvironment() {
        return this.environment;
    }

    public abstract void preRequestCert(Asset var1, Map var2);

    public abstract void preGetCert(Asset var1, Map var2);

    public abstract void postRequestCert(Asset var1, OA4MPResponse var2);

    public abstract void postGetCert(Asset var1, AssetResponse var2);

    public OA4MPResponse requestCert() {
        return this.requestCert((Identifier)null);
    }

    public OA4MPResponse requestCert(Identifier identifier) {
        HashMap m = new HashMap();
        return this.requestCert(identifier, m);
    }

    public AssetProvider getAssetProvider() {
        return this.assetProvider;
    }

    public void setAssetProvider(AssetProvider assetProvider) {
        this.assetProvider = assetProvider;
    }

    public OA4MPResponse requestCert(Identifier identifier, Map additionalParameters) {
        HashMap newAP = new HashMap();
        newAP.putAll(additionalParameters);
        AssetProvider assetProvider = this.getEnvironment().getAssetProvider();
        Asset asset = null;
        asset = identifier == null ? (Asset)((Object)assetProvider.get(false)) : assetProvider.get(identifier);
        OA4MPResponse response = this.requestCert(asset, newAP);
        asset.setPrivateKey(response.getPrivateKey());
        asset.setRedirect(response.getRedirect());
        this.getAssetStore().save((Identifiable)asset);
        return response;
    }

    public OA4MPResponse requestCert(Map additionalParameters) {
        return this.requestCert((Identifier)null, additionalParameters);
    }

    protected Identifier makeb64Uri(String x) {
        Base64String b64 = new Base64String(x.getBytes());
        Identifier id = BasicIdentifier.newID((String)(this.BASE64_URI_CAPUT + String.valueOf(b64)));
        return id;
    }

    protected KeyPair getNextKeyPair() {
        if (this.keyPair == null || this.getEnvironment().getKeypairLifetime() <= 0L || this.keypairExpiration < System.currentTimeMillis()) {
            this.keyPair = KeyUtil.generateKeyPair();
            this.keypairExpiration = System.currentTimeMillis() + this.getEnvironment().getKeypairLifetime();
        }
        return this.keyPair;
    }

    protected OA4MPResponse requestCert(Asset asset, Map additionalParameters) {
        HashMap requestParameters = new HashMap();
        requestParameters.putAll(additionalParameters);
        try {
            this.preRequestCert(asset, requestParameters);
            OA4MPResponse mpdsResponse = new OA4MPResponse();
            mpdsResponse.setPrivateKey(asset.getPrivateKey());
            DelegationRequest daReq = new DelegationRequest();
            daReq.setParameters(requestParameters);
            daReq.setClient(this.getEnvironment().getClient());
            daReq.setBaseUri(this.getEnvironment().getAuthorizationUri());
            DelegationResponse daResp = (DelegationResponse)this.getEnvironment().getDelegationService().process((Request)daReq);
            if (daResp.getAuthorizationGrant() != null) {
                asset.setToken(BasicIdentifier.newID((String)daResp.getAuthorizationGrant().getToken()));
                if (asset.getIdentifier() == null) {
                    asset.setIdentifier(this.makeb64Uri(daResp.getAuthorizationGrant().getToken().toString()));
                }
            }
            String skin = this.getEnvironment().getSkin();
            Object r = daResp.getRedirectUri().toString();
            if (skin != null) {
                r = (String)r + "&skin=" + skin;
            }
            mpdsResponse.setRedirect(URI.create((String)r));
            this.getAssetStore().save((Identifiable)asset);
            this.postRequestCert(asset, mpdsResponse);
            return mpdsResponse;
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new GeneralException("Error generating request", e);
        }
    }

    public AssetResponse getCert(String tempToken, Identifier identifier) {
        Asset asset = null;
        Identifier realId = null;
        realId = identifier == null ? this.makeb64Uri(tempToken) : identifier;
        if (realId == null) {
            throw new IllegalArgumentException("Error: no identifier found for this transaction. Cannot retrieve asset.");
        }
        asset = (Asset)((Object)this.getAssetStore().get(realId));
        if (asset == null && tempToken != null) {
            asset = this.getAssetStore().getByToken(BasicIdentifier.newID((String)tempToken));
        }
        if (asset == null) {
            String currentID = tempToken == null ? realId.toString() : tempToken;
            throw new IllegalArgumentException("Error:No asset with the given identifier \"" + currentID + "\" found. You might need to clear your cookies and retry the entire request.");
        }
        AuthorizationGrant ag = this.getEnvironment().getTokenForge().getAuthorizationGrant(new String[]{tempToken});
        return this.getCert(asset, ag);
    }

    protected Map<String, Object> getATParameters(Asset asset, AuthorizationGrant ag) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put((String)this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        return m;
    }

    protected Map<String, String> getAssetParameters(Asset asset) {
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put((String)this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        return m1;
    }

    protected AssetResponse getCert(Asset asset, AuthorizationGrant ag) {
        DelegatedAssetRequest dar = new DelegatedAssetRequest();
        dar.setAuthorizationGrant(ag);
        dar.setClient(this.getEnvironment().getClient());
        dar.setKeyID(this.getEnvironment().getKid());
        dar.setParameters(this.getATParameters(asset, ag));
        Map<String, String> m1 = this.getAssetParameters(asset);
        this.preGetCert(asset, m1);
        dar.setAssetParameters(m1);
        DelegatedAssetResponse daResp = (DelegatedAssetResponse)this.getEnvironment().getDelegationService().process((Request)dar);
        AssetResponse par = new AssetResponse();
        MyX509Certificates myX509Certificate = (MyX509Certificates)daResp.getProtectedAsset();
        par.setX509Certificates(myX509Certificate.getX509Certificates());
        par.setUsername((String)daResp.getAdditionalInformation().get("username"));
        this.postGetCert(asset, par);
        asset.setUsername(par.getUsername());
        asset.setCertificates(par.getX509Certificates());
        this.getEnvironment().getAssetStore().save((Identifiable)asset);
        return par;
    }
}

