/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.IdentifiableImpl;
import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import edu.uiuc.ncsa.security.util.crypto.MyPKCS10CertRequest;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import net.sf.json.JSONObject;

public class Asset
extends IdentifiableImpl {
    String username;
    X509Certificate[] certificates;
    PrivateKey privateKey;
    URI redirect;
    Date creationTime = new Date();
    MyPKCS10CertRequest certReq;
    Identifier token;
    protected String USERNAME_KEY = "username";
    protected String PRIVATE_KEY_KEY = "private_key";
    protected String X509_CERTS_KEY = "x509_certs";
    protected String CREATE_TIME_KEY = "create_time";
    protected String CERT_REQUEST_KEY = "cert_request";
    protected String REDIRECT_URI_KEY = "redirect_uri";
    protected String ASSET_ID_KEY = "asset_id";
    protected String TOKEN_KEY = "auth_grant";

    public Asset(Identifier identifier) {
        super(identifier);
    }

    public Identifier getToken() {
        return this.token;
    }

    public void setToken(Identifier token) {
        this.token = token;
    }

    public MyPKCS10CertRequest getCertReq() {
        return this.certReq;
    }

    public void setCertReq(MyPKCS10CertRequest certReq) {
        this.certReq = certReq;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public URI getRedirect() {
        return this.redirect;
    }

    public void setRedirect(URI redirect) {
        this.redirect = redirect;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public void setCertificates(X509Certificate[] certificates) {
        this.certificates = certificates;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toString() {
        Object out = "Asset[";
        out = (String)out + "id=" + this.getIdentifierString() + ", uri=" + String.valueOf(this.redirect);
        out = (String)out + "]";
        return out;
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isTrivial((String)this.getUsername())) {
            jsonObject.put((Object)this.USERNAME_KEY, (Object)this.getUsername());
        }
        if (this.getPrivateKey() != null) {
            jsonObject.put((Object)this.PRIVATE_KEY_KEY, (Object)KeyUtil.toPKCS8PEM((PrivateKey)this.getPrivateKey()));
        }
        if (this.getCertificates() != null && 0 < this.getCertificates().length) {
            jsonObject.put((Object)this.X509_CERTS_KEY, (Object)CertUtil.toPEM((X509Certificate[])this.getCertificates()));
        }
        jsonObject.put((Object)this.CREATE_TIME_KEY, (Object)Iso8601.date2String((Date)this.getCreationTime()));
        if (this.getCertReq() != null) {
            jsonObject.put((Object)this.CERT_REQUEST_KEY, (Object)CertUtil.fromCertReqToString((MyPKCS10CertRequest)this.getCertReq()));
        }
        if (this.getRedirect() != null) {
            jsonObject.put((Object)this.REDIRECT_URI_KEY, (Object)this.getRedirect().toString());
        }
        if (this.getIdentifier() != null) {
            jsonObject.put((Object)this.ASSET_ID_KEY, (Object)this.getIdentifierString());
        }
        if (this.getToken() != null) {
            jsonObject.put((Object)this.TOKEN_KEY, (Object)this.getToken().toString());
        }
        return jsonObject;
    }

    public void fromJSON(JSONObject jsonObject) {
        if (jsonObject.containsKey((Object)this.ASSET_ID_KEY)) {
            this.setIdentifier(BasicIdentifier.newID((String)jsonObject.getString(this.ASSET_ID_KEY)));
        }
        if (jsonObject.containsKey((Object)this.TOKEN_KEY)) {
            this.setToken(BasicIdentifier.newID((String)jsonObject.getString(this.TOKEN_KEY)));
        }
        if (jsonObject.containsKey((Object)this.REDIRECT_URI_KEY)) {
            this.setRedirect(URI.create(jsonObject.getString(this.REDIRECT_URI_KEY)));
        }
        if (jsonObject.containsKey((Object)this.USERNAME_KEY)) {
            this.setUsername(jsonObject.getString(this.USERNAME_KEY));
        }
        if (jsonObject.containsKey((Object)this.CREATE_TIME_KEY)) {
            try {
                this.setCreationTime(Iso8601.string2Date((String)jsonObject.getString(this.CREATE_TIME_KEY)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (jsonObject.containsKey((Object)this.X509_CERTS_KEY)) {
            try {
                this.setCertificates(CertUtil.fromX509PEM((String)jsonObject.getString(this.X509_CERTS_KEY)));
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
        }
        if (jsonObject.containsKey((Object)this.CERT_REQUEST_KEY)) {
            this.setCertReq(CertUtil.fromStringToCertReq((String)jsonObject.getString(this.CERT_REQUEST_KEY)));
        }
    }
}

