/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api.loader;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import edu.uiuc.ncsa.security.util.ssl.SSLConfigurationUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.inject.Provider;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.client.api.ClientEnvironment;
import org.oa4mp.client.api.ClientLoaderInterface;
import org.oa4mp.client.api.storage.AssetConverter;
import org.oa4mp.client.api.storage.AssetProvider;
import org.oa4mp.client.api.storage.AssetSerializationKeys;
import org.oa4mp.client.api.storage.AssetStore;
import org.oa4mp.client.api.storage.FSAssetStoreProvider;
import org.oa4mp.client.api.storage.MemoryAssetStore;
import org.oa4mp.client.api.storage.MultiAssetStoreProvider;
import org.oa4mp.client.api.storage.SQLAssetStoreProvider;
import org.oa4mp.delegation.client.DelegationService;
import org.oa4mp.delegation.common.servlet.DBConfigLoader;

public abstract class AbstractClientLoader<T extends ClientEnvironment>
extends DBConfigLoader<T>
implements ClientLoaderInterface<T> {
    public static final String ASSET_ENDPOINT = "getcert";
    public static final long defaultCertLifetime = 43200L;
    public static final long defaultMaxAssetLifetime = 2592000000L;
    protected Provider<AssetStore> assetStoreProvider;
    protected Provider<DelegationService> dsp;
    String baseURI = null;
    String wellKnownURI = null;
    T loader = null;
    SSLConfiguration sslConfiguration = null;
    ServiceClient wellKnownClient = null;
    JSONObject wellKnownConfiguration = null;

    protected AbstractClientLoader(ConfigurationNode node) {
        super(node);
    }

    protected AbstractClientLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    public abstract AssetProvider getAssetProvider();

    @Override
    public Provider<AssetStore> getAssetStoreProvider() {
        if (this.assetStoreProvider == null) {
            MultiAssetStoreProvider masp = new MultiAssetStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get());
            AssetConverter assetConverter = new AssetConverter(new AssetSerializationKeys(), this.getAssetProvider());
            this.assetStoreProvider = masp;
            masp.addListener((CfgEventListener)new FSAssetStoreProvider(this.cn, this.getAssetProvider(), assetConverter));
            masp.addListener((CfgEventListener)new SQLAssetStoreProvider(this.cn, "postgresql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider(), this.getAssetProvider(), assetConverter));
            masp.addListener((CfgEventListener)new SQLAssetStoreProvider(this.cn, "derby", (ConnectionPoolProvider<? extends ConnectionPool>)this.getDerbyConnectionPoolProvider(), this.getAssetProvider(), assetConverter));
            masp.addListener((CfgEventListener)new SQLAssetStoreProvider(this.cn, "mysql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider(), this.getAssetProvider(), assetConverter));
            masp.addListener((CfgEventListener)new SQLAssetStoreProvider(this.cn, "mariadb", (ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider(), this.getAssetProvider(), assetConverter));
            masp.addListener((CfgEventListener)new TypedProvider<MemoryAssetStore>(this.cn, "memoryStore", "assetStore"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public MemoryAssetStore get() {
                    return new MemoryAssetStore(AbstractClientLoader.this.getAssetProvider());
                }
            });
        }
        return this.assetStoreProvider;
    }

    protected abstract Provider<DelegationService> getDSP();

    protected URI checkURI(String uri, String componentName) {
        if (this.trivial(uri)) {
            throw new MyConfigurationException("Error: There is no " + componentName + " URI specified.");
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new MyConfigurationException("Error: The specified " + componentName + " is not a valid URI", (Throwable)e);
        }
    }

    protected String getCfgValue(String key) {
        return Configurations.getNodeValue((ConfigurationNode)this.cn, (String)key);
    }

    @Override
    public String getSkin() {
        return this.getCfgValue("skin");
    }

    @Override
    public long getKeypairLifetime() {
        String x = this.getCfgValue("keypairLifetime");
        long y = 0L;
        if (x == null || x.length() == 0) {
            return y;
        }
        try {
            y = Long.parseLong(x) * 1000L;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return y;
    }

    @Override
    public long getMaxAssetLifetime() {
        String x = this.getCfgValue("maxAssetLifetime");
        long y = 2592000000L;
        if (x == null || x.length() == 0) {
            return y;
        }
        try {
            y = Long.parseLong(x) * 1000L;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return y;
    }

    @Override
    public boolean isEnableAssetCleanup() {
        boolean doIt = false;
        try {
            doIt = Boolean.parseBoolean(this.getCfgValue("enableAssetCleanup"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return doIt;
    }

    protected URI createServiceURIOLD(String foundURI, String baseUri, String serviceEndpoint) {
        if (!this.trivial(foundURI)) {
            return this.checkURI(foundURI, serviceEndpoint);
        }
        if (this.trivial(baseUri)) {
            throw new MyConfigurationException("Error: No base uri for " + serviceEndpoint + " found");
        }
        return this.checkURI(baseUri + (baseUri.endsWith("/") ? "" : "/") + serviceEndpoint, serviceEndpoint);
    }

    protected URI createServiceURI(String foundURI, String endpoint, String wellKnownEntry) {
        if (!this.trivial(foundURI)) {
            return this.checkURI(foundURI, wellKnownEntry);
        }
        if (this.getWellKnownURI() != null) {
            return this.checkURI(this.getWellKnownString(wellKnownEntry), wellKnownEntry);
        }
        if (this.trivial(this.getServiceURI())) {
            return null;
        }
        return this.checkURI(this.getServiceURI() + "/" + endpoint, endpoint);
    }

    @Override
    public long getCertLifetime() {
        String certLifetimeString = this.getCfgValue("lifetime");
        if (!this.trivial(certLifetimeString)) {
            try {
                return Long.parseLong(certLifetimeString);
            }
            catch (Throwable t) {
                this.myLogger.warn("Error: parsing default lifetime for cert:" + t.getMessage());
            }
        }
        return 43200L;
    }

    boolean trivial(String x) {
        return x == null || 0 == x.length();
    }

    @Override
    public String getId() {
        String id = this.getCfgValue("id");
        if (this.trivial(id)) {
            throw new MyConfigurationException("Error: there is no identifier specified.");
        }
        return id;
    }

    @Override
    public URI getCallback() {
        String cb = this.getCfgValue("callbackUri");
        if (cb == null) {
            return null;
        }
        return this.checkURI(cb, "callback");
    }

    protected void checkProtocol(String b) {
        if (b == null) {
            return;
        }
        if (!b.toLowerCase().startsWith("https")) {
            throw new IllegalArgumentException("Error: the serviceUri must be https. You have \"" + b + "\"");
        }
    }

    @Override
    public String getServiceURI() {
        if (this.baseURI == null) {
            this.baseURI = this.getCfgValue("serviceUri");
            if (this.baseURI != null && this.baseURI.length() != 0) {
                this.baseURI = this.baseURI.endsWith("/") ? this.baseURI.substring(0, this.baseURI.length() - 1) : this.baseURI;
                this.checkProtocol(this.baseURI);
            }
        }
        return this.baseURI;
    }

    @Override
    public String getWellKnownURI() {
        if (this.wellKnownURI == null) {
            this.wellKnownURI = this.getCfgValue("wellKnownUri");
            if (this.wellKnownURI == null && this.getServiceURI() != null) {
                this.wellKnownURI = this.getServiceURI() + "/.well-known/openid-configuration";
            }
        }
        return this.wellKnownURI;
    }

    @Override
    public URI getAccessTokenURI() {
        return this.createServiceURI(this.getCfgValue("accessTokenUri"), "token", "token_endpoint");
    }

    @Override
    public URI getAssetURI() {
        String x = this.getCfgValue("assetUri");
        if (x == null) {
            return null;
        }
        this.checkProtocol(x);
        return this.createServiceURIOLD(x, this.getServiceURI(), ASSET_ENDPOINT);
    }

    @Override
    public URI getIssuer() {
        return this.createServiceURI(this.getCfgValue("issuerUri"), "issuer", "issuer");
    }

    @Override
    public URI getAuthorizeURI() {
        return this.createServiceURI(this.getCfgValue("authorizeUri"), "authorize", "authorization_endpoint");
    }

    public T load() {
        if (this.loader == null) {
            this.loader = (ClientEnvironment)this.createInstance();
        }
        return this.loader;
    }

    @Override
    public SSLConfiguration getSSLConfiguration() {
        if (this.sslConfiguration == null) {
            this.sslConfiguration = SSLConfigurationUtil.getSSLConfiguration((MyLoggingFacade)this.myLogger, (ConfigurationNode)this.cn);
        }
        return this.sslConfiguration;
    }

    public ServiceClient createServiceClient(URI host) {
        return new ServiceClient(host, this.getSSLConfiguration());
    }

    public ServiceClient getWellKnownClient() {
        if (this.wellKnownClient == null) {
            this.wellKnownClient = this.createServiceClient(URI.create(this.getWellKnownURI()));
        }
        return this.wellKnownClient;
    }

    public String getWellKnownString(String key) {
        if (this.getWellKnownConfiguration().containsKey((Object)key)) {
            return this.getWellKnownConfiguration().getString(key);
        }
        return null;
    }

    public Object getWellKnownValue(String key) {
        if (this.getWellKnownConfiguration().containsKey((Object)key)) {
            return this.getWellKnownConfiguration().get(key);
        }
        return null;
    }

    public JSONObject getWellKnownConfiguration() {
        if (this.wellKnownConfiguration == null) {
            String response = this.getWellKnownClient().doGet(new HashMap());
            this.wellKnownConfiguration = JSONObject.fromObject((Object)response);
        }
        return this.wellKnownConfiguration;
    }
}

