/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api.servlet;

import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.ExceptionHandlerThingie;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.client.api.servlet.ClientServlet;

public class ClientExceptionHandler
implements ExceptionHandler {
    MyLoggingFacade logger;
    protected ClientServlet clientServlet;

    public MyLoggingFacade getLogger() {
        return this.logger;
    }

    public ClientExceptionHandler(ClientServlet clientServlet, MyLoggingFacade logger) {
        this.logger = logger;
        this.clientServlet = clientServlet;
    }

    public void handleException(ExceptionHandlerThingie xh) throws IOException, ServletException {
        Throwable t = xh.throwable;
        HttpServletRequest request = xh.request;
        HttpServletResponse response = xh.response;
        if (DebugUtil.isEnabled()) {
            t.printStackTrace();
        }
        if (t.getCause() == null) {
            this.clientServlet.warn("2.a. Exception from the server: (no other cause)");
            request.setAttribute("cause", (Object)"(none)");
            request.setAttribute("stackTrace", (Object)"(none)");
        } else {
            this.clientServlet.warn("2.a. Exception from the server: " + t.getCause().getMessage());
            request.setAttribute("cause", (Object)t.getCause().getMessage());
            request.setAttribute("stackTrace", (Object)t.getCause());
        }
        this.clientServlet.error("Exception while trying to get cert. message:" + t.getMessage());
        String message = t.getMessage();
        if (t instanceof NullPointerException) {
            message = "null pointer";
        }
        if (t instanceof RuntimeException) {
            String path = this.getNormalizedContextPath();
            request.setAttribute("action", (Object)path);
            request.setAttribute("message", (Object)message);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.clientServlet.getCE().getErrorPagePath());
            return;
        }
        throw new ServletException("Error", t);
    }

    protected String getNormalizedContextPath() {
        Object path = this.clientServlet.getServletContext().getContextPath();
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }
}

