/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api.servlet;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.ClientEnvironment;
import org.oa4mp.client.api.ClientLoaderInterface;
import org.oa4mp.client.api.OA4MPService;

public abstract class ClientServlet
extends AbstractServlet {
    public static final String ACTION_KEY = "actionKey";
    public static final String ACTION_REDIRECT_VALUE = "redirect";
    public static final String REDIR = "redirect";
    HashMap<String, Asset> assetCache;
    public static final String OA4MP_CLIENT_REQUEST_ID = "oa4mp_client_req_id";
    public static Cleanup<Identifier, Asset> assetCleanup;
    static OA4MPService oa4mpService;

    protected HashMap<String, Asset> getAssetCache() {
        if (this.assetCache == null) {
            this.assetCache = new HashMap();
        }
        return this.assetCache;
    }

    public ClientEnvironment getCE() {
        return (ClientEnvironment)ClientServlet.getEnvironment();
    }

    public void loadEnvironment() throws IOException {
        environment = ClientServlet.getConfigurationLoader().load();
        oa4mpService = (OA4MPService)((ClientLoaderInterface)ClientServlet.getConfigurationLoader()).getServiceProvider().get();
    }

    public void destroy() {
        super.destroy();
        this.shutdownCleanup(assetCleanup);
    }

    protected void shutdownCleanup(Cleanup c) {
        if (c != null && !c.isStopThread()) {
            c.setStopThread(true);
            c.interrupt();
        }
    }

    public OA4MPService getOA4MPService() throws IOException {
        return oa4mpService;
    }

    protected String clearCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        String identifier = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(OA4MP_CLIENT_REQUEST_ID)) continue;
                identifier = cookie.getValue();
                cookie.setMaxAge(0);
                response.addCookie(cookie);
            }
        }
        return identifier;
    }
}

