/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api.servlet.sample;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.AssetResponse;
import org.oa4mp.client.api.servlet.ClientServlet;

public class SimpleReadyServlet
extends ClientServlet {
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Asset asset;
        this.info("2.a. Getting token.");
        String token = request.getParameter(SimpleReadyServlet.CONST((String)"oa4mp:token"));
        if (token == null) {
            this.warn("2.a. The token is " + (token == null ? "null" : token));
            GeneralException ge = new GeneralException("Error: This servlet requires parameters for the token.");
            request.setAttribute("exception", (Object)ge);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getCE().getErrorPagePath());
            return;
        }
        this.info("2.a Token found.");
        this.info("2.a. Getting the cert(s) from the service");
        String identifier = this.clearCookie(request, response);
        if (identifier == null && (asset = this.getCE().getAssetStore().getByToken(BasicIdentifier.newID((String)token))) != null) {
            identifier = asset.getIdentifierString();
        }
        AssetResponse assetResponse = null;
        if (identifier == null) {
            String msg = "Error: no cookie found. Cannot save certificates";
            this.warn(msg);
            this.debug("No cookie found");
            assetResponse = this.getOA4MPService().getCert(token, null);
        } else {
            assetResponse = this.getOA4MPService().getCert(token, BasicIdentifier.newID((String)identifier));
        }
        X509Certificate cert = assetResponse.getX509Certificates()[0];
        this.info("2.b. Done! Displaying success page.");
        request.setAttribute("certSubject", (Object)cert.getSubjectDN());
        request.setAttribute("cert", (Object)CertUtil.toPEM((X509Certificate[])assetResponse.getX509Certificates()));
        request.setAttribute("username", (Object)assetResponse.getUsername());
        Object contextPath = request.getContextPath();
        if (!((String)contextPath).endsWith("/")) {
            contextPath = (String)contextPath + "/";
        }
        request.setAttribute("action", contextPath);
        this.info("2.a. Completely finished with delegation.");
        this.logOK(request);
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getCE().getSuccessPagePath());
    }
}

