/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api.servlet.sample;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import java.security.PrivateKey;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.client.api.OA4MPResponse;
import org.oa4mp.client.api.servlet.ClientServlet;
import org.oa4mp.client.api.storage.AssetStoreUtil;

public class SimpleStartRequest
extends ClientServlet {
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.info("1.a. Starting transaction");
        OA4MPResponse gtwResp = null;
        Identifier id = AssetStoreUtil.createID();
        gtwResp = this.getOA4MPService().requestCert(id);
        Cookie cookie = new Cookie("oa4mp_client_req_id", id.getUri().toString());
        cookie.setMaxAge(900);
        cookie.setSecure(true);
        this.debug("id = " + String.valueOf(id.getUri()));
        response.addCookie(cookie);
        this.info("1.b. Got response. Creating page with redirect for " + gtwResp.getRedirect().getHost());
        if (this.getCE().isShowRedirectPage()) {
            request.setAttribute("redirect", (Object)"redirect");
            request.setAttribute("redirectUrl", (Object)gtwResp.getRedirect().toString());
            request.setAttribute("privateKey", (Object)KeyUtil.toPKCS8PEM((PrivateKey)gtwResp.getPrivateKey()));
            request.setAttribute("actionKey", (Object)"actionKey");
            request.setAttribute("action", (Object)"redirect");
            this.info("1.b. Showing redirect page.");
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getCE().getRedirectPagePath());
            return;
        }
        this.logOK(request);
        response.sendRedirect(gtwResp.getRedirect().toString());
    }
}

