/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.storage.AssetStore;
import org.oa4mp.client.api.storage.AssetStoreUtil;

public class FSAssetStore
extends FileStore<Asset>
implements AssetStore {
    public FSAssetStore(File file, IdentifiableProvider idp, MapConverter cp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(file, idp, cp, removeEmptyFiles, removeFailedFiles);
    }

    public FSAssetStore(File storeDirectory, File indexDirectory, IdentifiableProvider identifiableProvider, MapConverter converter, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(storeDirectory, indexDirectory, identifiableProvider, converter, removeEmptyFiles, removeFailedFiles);
    }

    @Override
    public Asset get(String identifier) {
        return AssetStoreUtil.get(identifier, this);
    }

    @Override
    public void save(String identifier, Asset identifiable) {
        AssetStoreUtil.save(identifier, identifiable, this);
    }

    public void realSave(boolean checkExists, Asset t) {
        super.realSave(checkExists, (Identifiable)t);
        try {
            if (t.getToken() != null) {
                this.createIndexEntry(t.getToken().toString(), t.getIdentifierString());
            }
        }
        catch (IOException e) {
            throw new GeneralException("Error serializing item " + String.valueOf((Object)t) + "to file ");
        }
    }

    @Override
    public Asset getByToken(Identifier token) {
        return (Asset)this.getIndexEntry(token.toString());
    }

    @Override
    public void putByToken(Asset asset) {
        this.realSave(false, asset);
    }

    public List<Asset> getMostRecent(int n, List<String> attributes) {
        return GenericStoreUtils.getMostRecent((Store)this, (int)n, attributes);
    }
}

