/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.MemoryStore;
import java.util.HashMap;
import java.util.List;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.storage.AssetConverter;
import org.oa4mp.client.api.storage.AssetSerializationKeys;
import org.oa4mp.client.api.storage.AssetStore;
import org.oa4mp.client.api.storage.AssetStoreUtil;

public class MemoryAssetStore
extends MemoryStore<Asset>
implements AssetStore {
    HashMap<Identifier, Asset> tokenCache = new HashMap();

    public MemoryAssetStore(IdentifiableProvider<Asset> identifiableProvider) {
        super(identifiableProvider);
    }

    @Override
    public Asset get(String identifier) {
        return AssetStoreUtil.get(identifier, this);
    }

    @Override
    public void save(String identifier, Asset v) {
        AssetStoreUtil.save(identifier, v, this);
    }

    @Override
    public Asset getByToken(Identifier token) {
        return this.tokenCache.get(token);
    }

    @Override
    public void putByToken(Asset asset) {
        this.tokenCache.put(asset.getToken(), asset);
    }

    public void save(Asset value) {
        super.save((Identifiable)value);
        if (value.getToken() != null) {
            this.putByToken(value);
        }
    }

    public XMLConverter<Asset> getXMLConverter() {
        return new AssetConverter(new AssetSerializationKeys(), (IdentifiableProvider<Asset>)this.identifiableProvider);
    }

    public List<Asset> getMostRecent(int n, List<String> attributes) {
        return GenericStoreUtils.getMostRecent((Store)this, (int)n, attributes);
    }
}

