/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.api.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Provider;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.storage.AssetSerializationKeys;
import org.oa4mp.client.api.storage.AssetStore;
import org.oa4mp.client.api.storage.AssetStoreTable;
import org.oa4mp.client.api.storage.AssetStoreUtil;

public class SQLAssetStore
extends SQLStore<Asset>
implements AssetStore {
    public static final String DEFAULT_TABLENAME = "transactions";

    public SQLAssetStore() {
    }

    public SQLAssetStore(ConnectionPool connectionPool, Table table, Provider<Asset> assetProvider, MapConverter<Asset> converter) {
        super(connectionPool, table, assetProvider, converter);
    }

    @Override
    public Asset get(String identifier) {
        return AssetStoreUtil.get(identifier, this);
    }

    @Override
    public void save(String identifier, Asset asset) {
        AssetStoreUtil.save(identifier, asset, this);
    }

    protected AssetStoreTable getAST() {
        return (AssetStoreTable)this.getTable();
    }

    @Override
    public Asset getByToken(Identifier token) {
        if (token == null) {
            return null;
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        Asset t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(this.getAST().getByTokenStatement());
            stmt.setString(1, token.toString());
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                Asset asset = null;
                return asset;
            }
            ColumnMap map = SQLAssetStore.rsToMap((ResultSet)rs);
            rs.close();
            stmt.close();
            t = (Asset)this.create();
            this.populate(map, (Identifiable)t);
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error getting object with identifier \"" + String.valueOf(token) + "\"", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        return t;
    }

    @Override
    public void putByToken(Asset asset) {
        this.save((Identifiable)asset);
    }

    public String getCreationTSField() {
        return ((AssetSerializationKeys)this.getMapConverter().getKeys()).creationTime(new String[0]);
    }
}

