/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.text.ParseException;
import java.util.Date;
import net.sf.json.JSONObject;
import org.oa4mp.client.api.Asset;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;

public class OA2Asset
extends Asset {
    AccessTokenImpl accessToken;
    RefreshTokenImpl refreshToken;
    Date issuedAt = new Date();
    String state;
    String nonce;
    protected String REFRESH_TOKEN_KEY = "refresh_token";
    protected String ACCESS_TOKEN_KEY = "access_token";
    protected String STATE_KEY = "state";
    protected String NONCE_KEY = "nonce";
    protected String ISSUED_AT_KEY = "issued_at";
    protected String ID_TOKEN_KEY = "id_token";
    IDTokenImpl idToken;

    public OA2Asset(Identifier identifier) {
        super(identifier);
    }

    public boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    public Date getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(Date issuedAt) {
        this.issuedAt = issuedAt;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public AccessTokenImpl getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessTokenImpl accessToken) {
        this.accessToken = accessToken;
    }

    public RefreshTokenImpl getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(RefreshTokenImpl refreshToken) {
        this.refreshToken = refreshToken;
    }

    public IDTokenImpl getIdToken() {
        return this.idToken;
    }

    public void setIdToken(IDTokenImpl idToken) {
        this.idToken = idToken;
    }

    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (!StringUtils.isTrivial((String)this.getNonce())) {
            json.put((Object)this.NONCE_KEY, (Object)this.getNonce());
        }
        if (!StringUtils.isTrivial((String)this.getState())) {
            json.put((Object)this.STATE_KEY, (Object)this.getState());
        }
        if (this.getIdToken() != null) {
            json.put((Object)this.ID_TOKEN_KEY, (Object)this.getIdToken().toJSON());
        }
        if (this.getAccessToken() != null) {
            json.put((Object)this.ACCESS_TOKEN_KEY, (Object)this.getAccessToken().toJSON());
        }
        if (this.getRefreshToken() != null) {
            json.put((Object)this.REFRESH_TOKEN_KEY, (Object)this.getRefreshToken().toJSON());
        }
        if (this.getIssuedAt() != null) {
            json.put((Object)this.ISSUED_AT_KEY, (Object)Iso8601.date2String((Date)this.getIssuedAt()));
        }
        return json;
    }

    public void fromJSON(JSONObject jsonObject) {
        JSONObject temp;
        super.fromJSON(jsonObject);
        if (jsonObject.containsKey((Object)this.NONCE_KEY)) {
            this.setNonce(jsonObject.getString(this.NONCE_KEY));
        }
        if (jsonObject.containsKey((Object)this.STATE_KEY)) {
            this.setState(jsonObject.getString(this.STATE_KEY));
        }
        if (jsonObject.containsKey((Object)this.ACCESS_TOKEN_KEY)) {
            AccessTokenImpl at = null;
            temp = jsonObject.getJSONObject(this.ACCESS_TOKEN_KEY);
            at = temp.containsKey((Object)"token_type") ? TokenFactory.createAT((JSONObject)temp) : TokenFactory.createAT((String)temp.getString("token"));
            this.setAccessToken(at);
        }
        if (jsonObject.containsKey((Object)this.ID_TOKEN_KEY)) {
            IDTokenImpl idToken1 = TokenFactory.createIDT((JSONObject)jsonObject.getJSONObject(this.ID_TOKEN_KEY));
            this.setIdToken(idToken1);
        }
        if (jsonObject.containsKey((Object)this.REFRESH_TOKEN_KEY)) {
            RefreshTokenImpl rt = null;
            temp = jsonObject.getJSONObject(this.REFRESH_TOKEN_KEY);
            rt = temp.containsKey((Object)"token_type") ? TokenFactory.createRT((JSONObject)temp) : TokenFactory.createRT((String)temp.getString("token"));
            this.setRefreshToken(rt);
        }
        if (jsonObject.containsKey((Object)this.ISSUED_AT_KEY)) {
            try {
                this.setCreationTime(Iso8601.string2Date((String)jsonObject.getString(this.ISSUED_AT_KEY)).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }
}

