/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.crypto.MyPKCS10CertRequest;
import java.net.URI;
import net.sf.json.JSONObject;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.storage.AssetConverter;
import org.oa4mp.client.loader.OA2Asset;
import org.oa4mp.client.loader.OA2AssetSerializationKeys;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;

public class OA2AssetConverter
extends AssetConverter {
    public OA2AssetConverter(SerializationKeys keys, IdentifiableProvider<Asset> provider) {
        super(keys, provider);
    }

    OA2AssetSerializationKeys getASK() {
        return (OA2AssetSerializationKeys)this.keys;
    }

    public Asset fromMap(ConversionMap<String, Object> map, Asset asset) {
        String state;
        JSONObject json;
        OA2Asset a = (OA2Asset)super.fromMap(map, asset);
        String rawCR = map.getString((Object)this.getASK().certReq(new String[0]));
        if (rawCR != null) {
            MyPKCS10CertRequest certReq = CertUtil.fromStringToCertReq((String)rawCR);
            a.setCertReq(certReq);
        }
        if (map.containsKey((Object)this.getASK().accessToken(new String[0])) && map.get((Object)this.getASK().accessToken(new String[0])) != null) {
            AccessTokenImpl accessToken;
            try {
                json = JSONObject.fromObject((Object)map.getString((Object)this.getASK().accessToken(new String[0])));
                accessToken = TokenFactory.createAT((JSONObject)json);
            }
            catch (Throwable t) {
                accessToken = new AccessTokenImpl(URI.create(map.getString((Object)this.getASK().accessToken(new String[0]))));
            }
            a.setAccessToken(accessToken);
        }
        if (map.containsKey((Object)this.getASK().refreshToken(new String[0])) && map.get((Object)this.getASK().refreshToken(new String[0])) != null) {
            RefreshTokenImpl refreshToken;
            try {
                json = JSONObject.fromObject((Object)map.getString((Object)this.getASK().refreshToken(new String[0])));
                refreshToken = TokenFactory.createRT((JSONObject)json);
            }
            catch (Throwable t) {
                refreshToken = new RefreshTokenImpl(URI.create(map.getString((Object)this.getASK().refreshToken(new String[0]))));
            }
            a.setRefreshToken(refreshToken);
        }
        if ((state = map.getString((Object)this.getASK().state(new String[0]))) != null) {
            a.setState(state);
        }
        a.setNonce(map.getString((Object)this.getASK().nonce(new String[0])));
        if (map.containsKey((Object)this.getASK().issuedAt(new String[0]))) {
            a.setIssuedAt(map.getDate((Object)this.getASK().issuedAt(new String[0])));
        }
        if (map.containsKey((Object)this.getASK().idToken(new String[0])) && map.get((Object)this.getASK().idToken(new String[0])) != null) {
            String idt = map.getString((Object)this.getASK().idToken(new String[0]));
            a.setIdToken(TokenFactory.createIDT((JSONObject)JSONObject.fromObject((Object)idt)));
        }
        return a;
    }

    public void toMap(Asset asset, ConversionMap<String, Object> map) {
        super.toMap(asset, map);
        OA2Asset a = (OA2Asset)super.fromMap(map, asset);
        if (a.getCertReq() != null) {
            map.put((Object)this.getASK().certReq(new String[0]), (Object)CertUtil.fromCertReqToString((MyPKCS10CertRequest)asset.getCertReq()));
        }
        if (a.getAccessToken() != null) {
            map.put((Object)this.getASK().accessToken(new String[0]), (Object)a.getAccessToken().toJSON().toString());
        }
        if (a.getRefreshToken() != null) {
            map.put((Object)this.getASK().refreshToken(new String[0]), (Object)a.getRefreshToken().toJSON().toString());
        }
        if (a.getState() != null) {
            map.put((Object)this.getASK().state(new String[0]), (Object)a.getState());
        }
        map.put((Object)this.getASK().nonce(new String[0]), (Object)a.getNonce());
        if (a.getIdToken() != null) {
            map.put((Object)this.getASK().idToken(new String[0]), (Object)a.getIdToken().toJSON().toString());
        }
        if (a.getIssuedAt() != null) {
            map.put((Object)this.getASK().issuedAt(new String[0]), (Object)a.getIssuedAt());
        }
    }
}

