/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader;

import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.Bootstrapper;
import edu.uiuc.ncsa.security.servlet.Initialization;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.servlet.ServletXMLConfigUtil;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import java.io.File;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.client.loader.OA2ClientLoader;
import org.oa4mp.client.loader.OA2ClientServletInitializer;

public class OA2ClientBootstrapper
extends Bootstrapper {
    public static final String OA2_CLIENT_CONFIG_FILE_KEY = "oa4mp:oauth2.client.config.file";
    public static final String OA2_CLIENT_CONFIG_NAME_KEY = "oa4mp:oauth2.client.config.name";
    public static final String DEFAULT_CONFIG_FILE_NAME = "client.xml";
    public static final String[] DEFAULT_CONFIG_LOCATIONS = new String[]{System.getProperty("user.home") + File.separator + "oa4mp" + File.separator + "client.xml", System.getProperty("user.home") + File.separator + "client.xml", System.getProperty("user.dir") + File.separator + "oa4mp" + File.separator + "client.xml", System.getProperty("user.dir") + File.separator + "client.xml", "/var/www/config/client.xml", "/var/www/config/oa4mp/client.xml"};

    public String getOa4mpConfigFileKey() {
        return OA2_CLIENT_CONFIG_FILE_KEY;
    }

    public String getOa4mpConfigNameKey() {
        return OA2_CLIENT_CONFIG_NAME_KEY;
    }

    public ConfigurationLoader getConfigurationLoader(ConfigurationNode node) throws MyConfigurationException {
        return new OA2ClientLoader(node);
    }

    public Initialization getInitialization() {
        return new OA2ClientServletInitializer();
    }

    public ConfigurationLoader loadFromDefaultLocations(MyLoggingFacade logger, String configName) throws Exception {
        logger.info("Searching for configuration name \"" + (configName == null ? "null" : configName) + "\"");
        for (String fileName : DEFAULT_CONFIG_LOCATIONS) {
            logger.info("Searching for configuration file \"" + fileName + "\"");
            File f = new File(fileName);
            if (!f.exists() || !f.isFile()) continue;
            try {
                logger.info("loading configuration \"" + (configName == null ? "(none)" : configName) + "\" from file " + fileName);
                ConfigurationNode node = XMLConfigUtil.findMultiNode((String)fileName, (String)configName, (String)"client");
                return this.getConfigurationLoader(node);
            }
            catch (Throwable throwable) {
                logger.info("  ** configuration not found for \"" + fileName + "\"");
            }
        }
        return null;
    }

    public ConfigurationLoader getConfigurationLoader(ServletContext servletContext) throws Exception {
        MyLoggingFacade logger = new MyLoggingFacade(((Object)((Object)this)).getClass().getSimpleName());
        String cfgName = servletContext.getInitParameter(this.getOa4mpConfigNameKey());
        String fileName = servletContext.getInitParameter(this.getOa4mpConfigFileKey());
        ServletDebugUtil.trace((Object)((Object)this), (String)("Attempting to load configuration \"" + cfgName + "\" from file \"" + fileName + "\""));
        logger.info("Starting to load configuration");
        try {
            ConfigurationLoader x = this.getConfigurationLoader(ServletXMLConfigUtil.findConfigurationNode((ServletContext)servletContext, (String)this.getOa4mpConfigFileKey(), (String)this.getOa4mpConfigNameKey(), (String)"client"));
            logger.info("Loaded configuration named " + cfgName + " from file " + fileName);
            return x;
        }
        catch (MyConfigurationException ce) {
            ServletDebugUtil.trace((Object)((Object)this), (String)"Did not find a configuration via the servlet context.");
            logger.info("Did not find a configuration via the servlet context:" + ce.getMessage());
            logger.info("No configuration found in servlet context. Trying default locations");
            String configName = servletContext.getInitParameter(this.getOa4mpConfigNameKey());
            ConfigurationLoader loader = this.loadFromDefaultLocations(logger, configName);
            if (loader != null) {
                return loader;
            }
            MyConfigurationException cx = new MyConfigurationException("Error: No configuration found anyplace. OA4MP client startup aborted!");
            ServletDebugUtil.error((Object)((Object)this), (String)"Failed to find any configuration.", (Throwable)cx);
            logger.error((Throwable)cx);
            throw cx;
        }
    }
}

