/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.oa4mp.client.api.ClientEnvironment;
import org.oa4mp.client.api.storage.AssetProvider;
import org.oa4mp.client.api.storage.AssetStore;
import org.oa4mp.delegation.client.DelegationService;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.TokenForge;

public class OA2ClientEnvironment
extends ClientEnvironment {
    URI issuer;
    URI deviceAuthorizationUri;
    Map<String, List<String>> additionalParameters;
    boolean useBasicAuth = false;
    Collection<String> scopes = null;
    String secret;
    String wellKnownURI = null;
    boolean oidcEnabled = true;
    boolean showIDToken = false;
    MetaDebugUtil metaDebugUtil = null;

    public OA2ClientEnvironment() {
    }

    public OA2ClientEnvironment(URI accessTokenUri, URI authorizationUri, URI callback, long certLifetime, String clientId, DelegationService delegationService, URI resourceServerUri, TokenForge tokenForge, AssetStore assetStore, boolean showRedirectPage, String errorPagePath, String redirectPagePath, String successPagePath, boolean oidcEnabled, boolean showIDToken, boolean useBasicAuth, URI deviceAuthorizationUri, URI issuer, MetaDebugUtil metaDebugUtil, String kid, JSONWebKeys jwks) {
        super(accessTokenUri, authorizationUri, callback, certLifetime, clientId, delegationService, null, null, null, resourceServerUri, tokenForge, assetStore, showRedirectPage, errorPagePath, redirectPagePath, successPagePath, kid, jwks);
        ServletDebugUtil.trace((Object)((Object)this), (String)("oidcEnabled?" + oidcEnabled));
        this.oidcEnabled = oidcEnabled;
        this.showIDToken = showIDToken;
        this.useBasicAuth = useBasicAuth;
        this.deviceAuthorizationUri = deviceAuthorizationUri;
        this.metaDebugUtil = metaDebugUtil;
        this.issuer = issuer;
    }

    public OA2ClientEnvironment(MyLoggingFacade logger, Map<String, String> constants, URI accessTokenUri, URI authorizationUri, URI callback, URI resourceServerUri, long certLifetime, String clientId, String skin, boolean enableAssetCleanup, long maxAssetLifetime, long keypairLifetime, AssetProvider assetProvider, Provider<Client> clientProvider, Provider<TokenForge> tokenForgeProvider, Provider<DelegationService> delegationServiceProvider, Provider<AssetStore> assetStoreProvider, boolean showRedirectPage, String errorPagePath, String redirectPagePath, String successPagePath, String secret, String kid, JSONWebKeys jwks, Collection<String> scopes, String wellKnownURI, boolean oidcEnabled, boolean showIDToken, boolean useBasicAuth, Map<String, List<String>> additionalParameters, URI deviceAuthorizationUri, URI issuer, MetaDebugUtil metaDebugUtil) {
        super(logger, constants, accessTokenUri, authorizationUri, callback, null, resourceServerUri, certLifetime, clientId, null, null, skin, enableAssetCleanup, maxAssetLifetime, keypairLifetime, assetProvider, clientProvider, tokenForgeProvider, delegationServiceProvider, assetStoreProvider, showRedirectPage, errorPagePath, redirectPagePath, successPagePath, kid, jwks);
        this.secret = secret;
        this.scopes = scopes;
        this.wellKnownURI = wellKnownURI;
        this.oidcEnabled = oidcEnabled;
        this.showIDToken = showIDToken;
        this.useBasicAuth = useBasicAuth;
        this.additionalParameters = additionalParameters;
        this.deviceAuthorizationUri = deviceAuthorizationUri;
        this.metaDebugUtil = metaDebugUtil;
        this.issuer = issuer;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public void setIssuer(URI issuer) {
        this.issuer = issuer;
    }

    public URI getDeviceAuthorizationUri() {
        return this.deviceAuthorizationUri;
    }

    public void setDeviceAuthorizationUri(URI deviceAuthorizationUri) {
        this.deviceAuthorizationUri = deviceAuthorizationUri;
    }

    public Map<String, List<String>> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setAdditionalParameters(Map<String, List<String>> additionalParameters) {
        this.additionalParameters = additionalParameters;
    }

    public boolean isUseBasicAuth() {
        return this.useBasicAuth;
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public String scopesToString(Collection<String> scopes) {
        Object out = null;
        boolean isFirst = true;
        for (String s : scopes) {
            if (isFirst) {
                out = s;
                isFirst = false;
                continue;
            }
            out = (String)out + " " + s;
        }
        return out;
    }

    public String scopesToString() {
        return this.scopesToString(this.getScopes());
    }

    public String getWellKnownURI() {
        return this.wellKnownURI;
    }

    public Client getClient() {
        if (this.client == null) {
            this.client = (Client)this.cp.get();
            this.client.setJWKS(this.getJWKS());
            this.client.setIdentifier((Identifier)new BasicIdentifier(this.getClientId()));
            this.client.setSecret(this.secret);
            this.client.setScopes(this.getScopes());
        }
        return this.client;
    }

    public boolean isOidcEnabled() {
        return this.oidcEnabled;
    }

    public void setScopes(Collection<String> scopes) {
        this.scopes = scopes;
    }

    public boolean isShowIDToken() {
        return this.showIDToken;
    }

    public MetaDebugUtil getMetaDebugUtil() {
        return this.metaDebugUtil;
    }

    public void setMetaDebugUtil(MetaDebugUtil metaDebugUtil) {
        this.metaDebugUtil = metaDebugUtil;
    }
}

